import ComponentBase from "../components/ComponentBase";

export default class Panel extends ComponentBase {
    constructor() {
        super();
    }

    initEvents() {
        if(this.closeBtns && this.closeBtns.length > 0){
            this.closeBtns.forEach(
                btn => { if(btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
            )
        }
        if(this.confirmBtns && this.confirmBtns.length > 0){
            this.confirmBtns.forEach(
                btn => { if(btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
            )
        }
        if(this.creditsOutBtns && this.creditsOutBtns.length > 0){
            this.creditsOutBtns.forEach(
                btn => { if(btn) btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.creditsOut, this) } 
            )
        }
        
    }
    removeEvents() {
        if(this.closeBtns && this.closeBtns.length > 0){
            this.closeBtns.forEach(
                btn => { if(btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
            )
        }
        if(this.confirmBtns && this.confirmBtns.length > 0){
            this.confirmBtns.forEach(
                btn => { if(btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this) }
            )
        }
        
        if(this.creditsOutBtns && this.creditsOutBtns.length > 0){
            this.creditsOutBtns.forEach(
                btn => { if(btn) btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.creditsOut, this) } 
            )
        }
    }

    protected get closeBtns(): eui.Button[] { return [this['closeBtn']] }
    protected get confirmBtns(): eui.Button[] { return [this['confirmBtn']]}
    protected get creditsOutBtns(): eui.Button[] { return [this['creditsOutBtn']] }

    onTouchTap(): any {
        this.hidePanel();
    }

    hidePanel() {
        this.destroy();
        this.dispatchEvent(new egret.Event('onDestroy'));
    }
    
    creditsOut(){
        this.destroy();
        this.dispatchEvent(new egret.Event('onCreditsOut'));
    }

}