import StartScene from "./StartScene";
import Monkey from "./Monkey";

export default class GuideCtrl extends egret.EventDispatcher {
    private _main: StartScene;
    private _tag: boolean;
    private _guideTop: egret.Sprite;
    constructor(view: StartScene) {
        super();
        this._main = view;
        this.init();
    }

    start() {
        if (this._tag) {
            this._main.guideView.destroy();
            this._main.addTouchEvent();
            this.doComplete();
        }
        else {
            this.startGuide();
        }
    }

    private startGuide() {
        this._guideTop = new egret.Sprite();
        this._main.topLay.addChild(this._guideTop);
        this._main.monkey.once('onStartShaking', this.onMonkeyStartShaking, this);
        this._main.boxListCtrl.boxs[0].once('onPassMiddle', this.onPassMiddle, this);
        this._main.boxListCtrl.updateSpeed(__boxMoveSpeed__ * 10);
    }

    onPassMiddle() {
        this._main.boxListCtrl.pause();
        this.addGuide();
    }

    tips;
    async addGuide() {
        const hand = await RES.getResAsync('guide_hand_png');
        const tips = await RES.getResAsync('guide_tips_png');
        const guide_dialog = await RES.getResAsync('guide_dialog_png');
        this.doComplete();
        await this.showtipsAni(tips);
        await this.showhandAni(hand);
        await this.showguideAni(guide_dialog);
    }

    private doComplete() {
        this.dispatchEvent(new egret.Event(egret.Event.COMPLETE));
    }

    enableInteract() {
        if (!this._tag)
            this._main.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onTouch, this);
    }

    async showtipsAni(texture) {
        const pic = new egret.Bitmap(texture);
        pic.anchorOffsetX = pic.width >> 1;
        pic.anchorOffsetY = pic.height >> 1;
        this._guideTop.addChild(pic);
        return new Promise((r) => {
            egret.Tween.get(pic).set({ x: 0, y: 710 + 130 })
                .to({ x: 750 / 2 }, 200, egret.Ease.getBackOut(3)).wait(200)
                .call(() => r(pic));
        });
    }

    async showhandAni(texture) {
        const pic = new egret.Bitmap(texture);
        pic.anchorOffsetX = pic.width >> 1;
        pic.anchorOffsetY = pic.height >> 1;
        this._guideTop.addChild(pic);
        return new Promise((r) => {
            egret.Tween.get(pic).set({ x: 750, y: 930 + 130 }).to({ x: 750 / 2 }, 200, egret.Ease.getBackOut(3))
                .wait(200).call(() => r(pic));
        });
    }

    async showguideAni(texture) {
        const pic = new egret.Bitmap(texture);
        pic.anchorOffsetX = pic.width >> 1;
        pic.anchorOffsetY = pic.height >> 1;
        this._guideTop.addChild(pic);
        return new Promise((r) => {
            egret.Tween.get(pic).set({ x: 750, y: 200 }).to({ x: 200 }, 200, egret.Ease.getBackOut(3))
                .wait(200).call(() => r(pic));
        });
    }


    onTouch() {
        if (!this._main.checkCanDoAtion()) return;
        this._main.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onTouch, this);
        this._main.boxListCtrl.updateSpeed(__boxMoveSpeed__);
        this.setTag();
        this._main.guideView.destroy();
        egret.Tween.get(this._guideTop).to({ alpha: 0 }, 200).call(() => {
            this._main.topLay.removeChild(this._guideTop);
        }, this);
        this._main.doAction();
        this._main.addTouchEvent();
    }

    onMonkeyStartShaking() {
        this._main.monkey.stop(Monkey.RANGE / 3)
    }

    private init() {
        this._tag = localStorage.getItem('guide') === '1';
    }

    setTag() {
        localStorage.setItem('guide', '1');
    }
}