import { Buried } from "../src/Buried";
export class NetBuried {
    // constructor() { }
    exposure = []
    dpm = []
    dcm = []

    showLog(i, d) {
        var appId = window.CFG.appID;
        var oaId = window.CFG.projectId;
        if (d) {
            this.dpm[i] = `${appId}.110.${i}.${d}`;
        } else {
            this.dpm[i] = `${appId}.110.${i}.1`;
        }
        this.dcm[i] = `202.${oaId}.0.0`;
        this.exposure[i] = Buried.createExposure(this.dpm[i], this.dcm[i]);
        this._showLog(this.exposure[i]);
    }

    clickLog(i, d) {
        var appId = window.CFG.appID;
        var oaId = window.CFG.projectId;
        if (d) {
            this.dpm[i] = `${appId}.110.${i}.${d}`;
        } else {
            this.dpm[i] = `${appId}.110.${i}.1`;
        }
        this.dcm[i] = `202.${oaId}.0.0`;
        this.exposure[i] = Buried.createExposure(this.dpm[i], this.dcm[i]);
        this._clickLog(this.exposure[i]);
    }

    /**
    * 兑吧点击埋点
    * @param {IExposureData} exposure
    */
    _clickLog(exposure) {
        const net = {
            name: 'clickLog',
            uri: '/log/click',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        this.send(net);
    }

    /**
     * 兑吧曝光埋点
     * @param {IExposureData} exposure
     */
    _showLog(exposure) {
        const net = {
            name: 'showLog',
            uri: exposure.domain + '/exposure/standard',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        this.send(net);
    }

    /**
     * 发送请求
     * @param net 
     */
    send(net) {
        let realUrl = net.uri;
        //url加参数等特殊需求（例如再玩一次需要在dostart接口的url上加埋点）
        if (net.addUrl) {
            realUrl += net.addUrl;
        }
        window['$'].ajax({
            type: net.type,
            url: realUrl,
            dataType: net.dataType,
            data: net.param,
            async: true,
            success: (result) => {
            },
            error: (message) => {
            }
        });
    }

}