'use strict';

import React, { Component } from 'react';
import { USE_IMG_RES, MODAL_NAME, MODAL_TYPE, ERROR_MESSSAGE } from '../../constant';
import resList from '../../resconfig/resList';
import API from '../../api';
import { Toast, getModalHoc, Loading } from 'spark-design';
import loading from '../../components/comloadingscene/comloadingscene.jsx';
import './pagewishscene.less';
import { ICBCUtil } from '../../icbc_core'
import { mHistory } from '../../BaseRouter.jsx';
import nicknameModal from '../../components/comnickpanel/comnickpanel.jsx';
import guideModal from '../../components/comguidepanel/comguidepanel.jsx';
import openPrize from '../../components/comshowprizepanel/comshowprizepanel.jsx';
import prizePanel from '../../components/comprizepanel/comprizepanel.jsx';
import prizeRegret from '../../components/comregretpanel/comregretpanel.jsx';
import { getPxToken } from '../../libs/spark_gettoken';
import { NetBuried } from '../../NetBuried'

const NicknameModal = getModalHoc(nicknameModal);
const GuideModal = getModalHoc(guideModal);
const LoadingModal = getModalHoc(loading);
const OpenPrize = getModalHoc(openPrize);
const PrizePanel = getModalHoc(prizePanel);
const PrizeRegret = getModalHoc(prizeRegret);
class Pagewishscene extends Component {
  constructor(props) {
    super(props);
    this.state = {
      resList: resList,
      clickNum: -1,
      chooseList: [],
      modalType: "",
      wishTagsPositionList: [
        { left: 2, top: 76 },
        { left: 8, top: 50 },
        { left: 20, top: 35 },

        { left: 18, top: 65 },
        { left: 35, top: 28 },
        { left: 38, top: 60 },

        { left: 30, top: 79 },
        { left: 48, top: 70 },
        { left: 58, top: 50 },

        { left: 68, top: 75 },
        { left: 78, top: 58 },
        { left: 69, top: 30 },

        { left: 87, top: 40 },
        { left: 52, top: 25 },

        // { left: 90, top: 70 },
        // { left: 28, top: 50 },
      ],//所有tag的位置,直接写死给出   , "15字成语","16字成语"
      wishTagsList: [],//所有的tag
      wishName: "",
      loadingTime: 0,
      indexData: {},
      showGuide: "",
      prizeData: {},
      prizeResult: {},
      pass: true

    };
  }
  componentDidMount() {
    //动画调试
    // this.modalControl(MODAL_NAME.P_LOADING);
    // this.modalControl(MODAL_NAME.P_PRIZE_OPEN);
    this.initPagesData();
  }
  /**
   * 初始化该页数据
   */
  async initPagesData() {
    Loading.show();
    this.showBuried(4)
    let { data, success, message, code } = await API.getIndexInfo();
    console.log(data);
    if (!success) {
      //失败
      Loading.hide();
      Toast(ERROR_MESSSAGE(code), 2000);
    } else {
      let { nicknameFlg, newHandFlg, wishCountFlg } = data;
      Loading.hide();
      if (!nicknameFlg) {
        //新手
        this.modalControl(MODAL_NAME.P_NICK);
      } else {
        //接口调用成功
        this.setState({
          indexData: data
        })
        console.log('data>>>>>>>>', data);
        //是否达到许愿上限
        if (wishCountFlg) {
          Toast('每天可以许2次愿望，看看之前的许愿结果吧～', 2000)
          setTimeout(() => {
            mHistory.push({ pathname: '/b' });
          }, 1000)
        } else {
          //是否填了昵称
          if (newHandFlg) {
            console.log('为新手');
            //是否为新手
            this.modalControl(MODAL_NAME.P_GUIDE);
          } else {
            this.modalControl();
            this.getWishTagsList();
          }
        }
      }
    }
  }

  showBuried(i) {
    let netBuried = new NetBuried();
    netBuried.showLog(i);
  }
  clickBuried(i) {
    let netBuried = new NetBuried();
    netBuried.clickLog(i);
  }

  backScene() {
    mHistory.push({ pathname: '/' });
  }

  closeNickname(pass) {
    if (pass) {
      this.modalControl(MODAL_NAME.P_GUIDE);
    }
    else {
      this.backScene();
    }
  }


  /**
   * 获取所有的许愿签
   */
  async getWishTagsList() {
    let { success, data, code } = await API.getWishIndexInfo();
    if (success) {
      console.log("data-------", data.wishPool);
      this.setState({
        wishTagsList: data.wishPool
      });
      console.log('》》》》》》', this.state.wishTagsList);
      let { wishTagsPositionList } = this.state;
      console.log('wishTagsPositionList', this.state.wishTagsPositionList);
      let tagsNum = data.wishPool.length;
      console.log('tagsNum=====', tagsNum);
      for (let i = 0; i < tagsNum; i++) {
        let item1 = document.getElementById(`tag${i}`).style;
        let item2 = document.getElementById(`tlabel${i}`).style;
        item1.left = `${wishTagsPositionList[i].left}vw`;
        item1.top = `${wishTagsPositionList[i].top}vw`;
        item2.left = `${wishTagsPositionList[i].left}vw`;
        item2.top = `${wishTagsPositionList[i].top}vw`;
      }
    }
    else {
      Toast(ERROR_MESSSAGE(code), 2000);
    }
    //接口获取心愿信息
    // let data = ["一字成语", "二字成语", "三字成语", "四字成语", "五字成语", "六字成语", "七字成语", "八字成语", "九字成语", "十字成语", "11字成语", "12字成语", "13字成语", "14字成语"];
    // this.setWishTagsPosition(data, this.state.wishTagsPositionList); , "15字成语", "16字成语"
  }
  /**
   * 点击当前的心愿tag
   * @param {*} item 
   * @param {*} index 
   */
  clickCurTag(index) {
    let { chooseList, wishName, pass } = this.state;
    console.log('点击chooseList===', chooseList, '点击wishName----', wishName || "null", chooseList.includes(-1), !wishName);
    if (chooseList.includes(index)) {
      this.setState({
        chooseList: chooseList.filter((i) => { return (index != i) })
      })
    }
    else {

      if (chooseList.length < 5) {
        this.setState({
          chooseList: chooseList.concat([index])
        })
      }
      else {
        if (pass) {
          this.setState({
            pass: false
          })
          Toast("每天可以许5个愿望，还有别的愿望，明天再来吧～", 2000);
          setTimeout(() => {
            this.setState({
              pass: true
            })
          }, 2000)
        }
      }
    }
  }
  onInputChangeValue() {
    let { chooseList, wishName } = this.state;
    if (chooseList.length < 5 || chooseList.includes(-1)) {
      let inputValue = document.getElementById("inputWish").value;
      console.log('>>>>>.......', inputValue);
      this.setState({
        wishName: inputValue,
      })
      console.log('输入框为空----', this.state.wishName);
      if (!chooseList.includes(-1)) {
        this.setState({
          chooseList: chooseList.concat(-1)
        })
      }
      else {
        console.log('输入框变化值---', inputValue);
        if (!inputValue) {
          chooseList = chooseList.filter((item) => { return item != -1 });
          // console.log('>>>>',chooseList.filter((item) => { return item != -1 }));
          this.setState({
            chooseList: chooseList
          })
          console.log("没有心愿去除", this.state.chooseList);
        }
      }
    } else {
      this.setState({
        wishName: '',
      })
      let { pass } = this.state;
      if (pass) {
        this.setState({
          pass: false
        })
        Toast("每天可以许5个愿望，还有别的愿望，明天再来吧～", 2000);
        setTimeout(() => {
          this.setState({
            pass: true
          })
        }, 2000)
      }
    }
  }

  modalControl(key) {
    this.setState({
      modalType: MODAL_TYPE[key]
    })
  }

  /**
   * 展示加载
   */
  showLoading() {
    console.log(")))))))))))))");
    let time = Date.now() + 3 * 1000;
    console.log('.....', Date.now(), time);
    this.setState({
      loadingTime: time
    })
    this.modalControl(MODAL_NAME.P_LOADING);
  }
  /**
   * 加载完毕播放开奖动画
   */
  showOpenPrize() {
    console.log('场景跳转---*********---');
    // this.startOpenPrize();
    this.modalControl(MODAL_NAME.P_PRIZE_OPEN);//动画播放
    setTimeout(() => {
      let { success, data, code } = this.state.prizeResult;
      if (success) {
        this.setState({
          prizeData: data
        })
        this.modalControl(MODAL_NAME.P_PRIZE_RESULT);//出奖弹窗
      } else {
        if (code == "600020") {
          this.modalControl(MODAL_NAME.P_PRIZE_REGRET);
        } else {
          Toast(ERROR_MESSSAGE(code), 2000);
          mHistory.push({ pathname: '/b' });
        }
      }
    }, 1500)

  }
  /**
    * 场景开始开奖
    */
  async startOpenPrize() {

    let str = /^[a-zA-Z0-9\u4e00-\u9fa5]+$/;
    let clean = /[\!|\~|\`|\#|\%|\^|\&|\*|\(|\)|\-|\_|\+|\=|\||\\|\{|\}|\;|\:|\"|\'|\,|\<|\.|\>|\/|\?/\，/\。/\；/\：/\“/\”/\》/\《/\|/\{/\}/\、/\!/\~/\`]/g;
    // console.log(str2.test('1'), str2.test("a"), str2.test("安"), str2.test(","));
    let { chooseList, wishName, pass } = this.state;
    console.log(str.test(wishName.replace(clean, "")))
    // return;
    if (str.test(wishName.replace(clean, "")) || !wishName) {
      this.clickBuried(4)
      console.log("许愿结果", chooseList);
      let wishIds = chooseList.filter((item) => { return item != -1 }).map(item => { return item = +item + 1 }).join(',');
      console.log('{{{{{{{{{', wishIds);
      if (pass) {
        this.setState({
          pass: false
        })
        getPxToken(async token => {
          let postObj = { token: "" };
          postObj.token = token;
          postObj.wishIds = wishIds;
          if (chooseList.includes(-1) && wishName) {
            postObj.userWishName = wishName;
          }
          console.log('/////////////', postObj);
          let result = await API.getOpenPrize(postObj);
          let { success, code } = result;
          if (!success && code !== '600020') {
            Toast(ERROR_MESSSAGE(code), 2000);
            return;
          }
          this.setState({
            prizeResult: result
          })
          this.showLoading();
        })
        setTimeout(() => {
          this.setState({
            pass: true
          })
        }, 2000)
      }
    } else {
      if (pass) {
        this.setState({ pass: false });
        Toast('心愿中不可以输入空格、emoji图案哦', 2000);
        setTimeout(() => {
          this.setState({ pass: true });
        }, 2000)
      }
    }
  }
  jumpResultScene() {
    mHistory.push({ pathname: "/b" })
  }
  /**
   * 关闭新手指导
   */
  closeGuidePanel() {
    this.modalControl();
    this.getWishTagsList();
  }

  render() {
    let { wishTagsList, clickNum, chooseList, wishName, modalType, loadingTime, showGuide, prizeData } = this.state;
    // console.log('showGuide====', showGuide);
    return (
      <div className="wishscene ">
        <div className="wishpage ">
          <img className="bg " src={this.state.resList['85e8f480-2736-404d-88f5-0498715afaba'].url} />
          {/* <img className="taglight " src={USE_IMG_RES.LIGHT_IMG} />
          <img className="tagshadow " src={USE_IMG_RES.SHADOW_IMG} /> */}
          {wishTagsList.map((item, index) => {
            return (
              <div key={index}>
                <div>
                  <img className={chooseList.includes(index) ? "taglight" : "tagshadow"} id={`tag${index}`}
                    src={chooseList.includes(index) ? USE_IMG_RES.LIGHT_IMG : USE_IMG_RES.SHADOW_IMG}
                    onClick={() => { console.log('------'); }} />
                  <label className="tagLabel " onClick={() => { this.clickCurTag(index) }} id={`tlabel${index}`}>{wishTagsList[index].wishName}</label>
                </div>
              </div>
            )
          })}
          {/* id={`tagLabel${index}`} */}
          {/* onClick={() => { this.loadingAnimation() }} */}
          <img className="wishnobtn " src={this.state.resList['a53a2588-d27f-4e02-94dc-14fea82c76f2'].url} />
          {chooseList.length == 5
            &&
            <img className="wishbtn " id="startLoading" src={this.state.resList['f19f3428-2f8b-4aa3-afab-db779b616020'].url} onClick={() => { console.log("choose=====", chooseList, 'wishName', wishName || "null"); this.startOpenPrize() }} />}
          <label className="wishbtnLab ">{`种下我的心愿树(${chooseList.length}/5)`}</label>
          <div className="wishinputs ">
            <img className="wishinputbg " src={this.state.resList['4ef09ae1-195d-473e-8eaf-06eac70dd005'].url} />
            <input className="wishinput " value={wishName} id="inputWish" onChange={() => { this.onInputChangeValue(wishName) }} maxLength={10} placeholder="还可以在这里输入心愿哦!(0/10)"></input>
          </div>
          {/* <img className="backHomeBtn" src={resList['66eb7ce1-0581-438a-9798-d140f86623b3'].url} onClick={() => { console.log('>.........', ICBCUtil.returnBack()); ICBCUtil.returnBack() }} /> */}
        </div>
        {modalType == MODAL_TYPE[MODAL_NAME.P_LOADING] && <LoadingModal time={loadingTime} onClose={() => { this.showOpenPrize() }}></LoadingModal>}
        {modalType == MODAL_TYPE[MODAL_NAME.P_GUIDE] && <GuideModal time={loadingTime} onClose={() => { this.closeGuidePanel() }}></GuideModal>}
        {modalType == MODAL_TYPE[MODAL_NAME.P_NICK] && <NicknameModal time={loadingTime} onClose={(pass) => { this.closeNickname(pass); }}></NicknameModal>}
        {modalType == MODAL_TYPE[MODAL_NAME.P_PRIZE_OPEN] && <OpenPrize></OpenPrize>}
        {modalType == MODAL_TYPE[MODAL_NAME.P_PRIZE_RESULT] && <PrizePanel onClose={() => { this.modalControl(); this.jumpResultScene() }} data={prizeData}></PrizePanel>}
        {modalType == MODAL_TYPE[MODAL_NAME.P_PRIZE_REGRET] && <PrizeRegret onClose={() => { this.modalControl(); this.jumpResultScene() }} data={prizeData}></PrizeRegret>}
      </div>
    );
  }
}
export default Pagewishscene;
