'use strict';

import React, { Component } from 'react';
import resList from '../../resconfig/resList';
import API from '../../api';
import { MODAL_NAME, MODAL_TYPE, JUMP_URL, ERROR_MESSSAGE } from '../../constant'
import './pageresultscene.less';
import { Toast, getModalHoc } from 'spark-design';
import openPrize from '../../components/comshowprizepanel/comshowprizepanel.jsx';
import ruleMoadl from '../../components/comrulepanel/comrulepanel.jsx';
import awardModal from "../../components/comawardpanel/comawardpanel.jsx";
import { mHistory } from '../../BaseRouter.jsx';
import { ICBCUtil } from '../../icbc_core'
import { format } from 'prettier';
const RuleModal = getModalHoc(ruleMoadl);
const AwardModal = getModalHoc(awardModal);
const OpenPrize = getModalHoc(openPrize);
class Pageresultscene extends Component {
  constructor(props) {
    super(props);
    this.state = {
      resList: resList,
      modalType: "",
      resultList: [{ wishName: "" }, { wishName: "" }, { wishName: "" }, { wishName: "" }, { wishName: "" }],
      resultObj: {},
      shareImg: "",
      wishLimit: false,
      rule: "",
      pass: true

    };
  }

  componentDidMount() {
    this.getResultMsg();
    console.log(">>>...........>>", this.props);
  }

  modalControl(key) {
    this.setState({
      modalType: MODAL_TYPE[key]
    })
    console.log("========", key || "null", this.state.modalType);
  }

  async getResultMsg() {
    //获取接口的返回结果信息
    let { success, data, message, code } = await API.wishResultData();
    if (success) {
      console.log('许愿结果》》》', data.wishData.wishList);
      let wishs = data.wishData.wishList;
      //获取奖品接口
      this.setState({
        resultList: wishs,
        resultObj: {
          nickname: data.nickName,
          content: data.wishData.blessing
        },
        wishLimit: data.wishCountFlg,
        shareImg: "12"
      })
    } else {
      Toast(ERROR_MESSSAGE(code), 2000)
    }
  }

  /**
    * 跳转链接
    * @param {*} url 
    */
  jumpUrl(url) {
    console.log('url---------', url);
    this.state.isDo = true;
    console.log("isdo-----", this.state.isDo);
    setTimeout(() => {
      this.setState({
        isDo: true
      })
    }, 2000)
    if (this.state.isDo) {
      this.setState({
        isDo: false
      })
      if (url) {
        window.location.href = url;
      } else {
        Toast("请检查网络", 2000);
      }
    }
  }

  againWish() {
    let { wishLimit, pass } = this.state;
    if (wishLimit) {
      if (pass) {
        this.setState({
          pass: false
        })
        Toast('今天已经许愿2次啦，明天再来吧~', 2000);
        setTimeout(() => {
          this.setState({
            pass: true
          })
        }, 2000)
      }

    } else {
      console.log('场景跳转---------');
      mHistory.push({ pathname: '/' })
    }
  }

  async setRuleData() {
    let { success, data, message, code } = await API.getRule();
    console.log('data-----', data);
    if (success) {
      this.setState({
        rule: data
      })
      this.modalControl(MODAL_NAME.P_RULE);
    } else {
      Toast(ERROR_MESSSAGE(code), 2000)
    }
  }


  shareMsg() {
    let { pass } = this.state;
    if (pass) {
      this.setState({
        pass: false
      })
      Toast('可截图保存到相册，分享你的许愿树哦!', 2000);
      setTimeout(() => {
        this.setState({
          pass: true
        })
      }, 2000)
    }
  }

  returnHomeBtn() {
    Toast('返回=====')
    // ICBCUtil.returnBack()
    window.location.href = "native://finish";
  }


  render() {
    let { modalType, resultList, resultObj, shareImg, rule } = this.state;
    return (
      <div className="resultscene ">
        <img className="bg " src={this.state.resList['93ef9977-c6a5-4e96-ad2b-47b5b717dc19'].url} />

        <div className="wishresult ">
          <img className="wishbg " src={this.state.resList['57172e95-f331-47b6-af37-9464c39ba69d'].url} />
          <img className="shareImg " src={this.state.resList['0dd921f7-14be-4900-b404-24574796ac07'].url} />
          <div className="wishtags ">
            <div className="tag4 ">
              <img className="tagb4 " src={this.state.resList['805e70ea-e0b5-44b2-989d-9da28a9920ae'].url} />
              <span className="tagl4 ">{resultList[3].wishName || "一帆风顺"}</span>
            </div>
            <div className="tag3 ">
              <img className="tagb3 " src={this.state.resList['d9f830d6-cf5b-4998-9980-9a3cdec3fa54'].url} />
              <span className="tagl3 ">{resultList[2].wishName || "十全十美"}</span>
            </div>
            <div className="tag2 ">
              <img className="tagb2 " src={this.state.resList['d9d55c57-c453-4e60-9244-5c55c3e67566'].url} />
              <span className="tagl2 ">{resultList[1].wishName || "心想事成"}</span>
            </div>
            <div className="tag1 ">
              <img className="tagb1 " src={this.state.resList['25fbfc7d-467c-4850-b236-4249c4251299'].url} />
              <span className="tagl1 ">{resultList[0].wishName || "万事如意"}</span>
            </div>
            <div className="tag5 ">
              <img className="tagb5 " src={this.state.resList['b38f3eab-7b10-444a-a46b-68a326918d10'].url} />
              <span className="tagl5 ">{resultList[4].wishName}</span>
            </div>
          </div>
          <span className="nickname ">{resultObj.nickname || "全体员工"}</span>
          <span className="wishcontent ">
            {resultObj.content || "这个世界真的有人过着你想过的生活， 你要相信你也可以。 致敬2021，致敬你的梦想，祝心想事成！"}
          </span>
        </div>
        <img className="awardbtn2 " onClick={() => { this.jumpUrl(JUMP_URL.AWARD_URL); }} src={this.state.resList['df88f4c3-4e66-4936-84dc-654eb165ae93'].url} />
        <img className="rulebtn2 " onClick={() => { this.setRuleData() }} src={this.state.resList['1b800919-334c-4223-a299-3946e453fc80'].url} />
        <img className="againbtn point7" onClick={() => { this.againWish() }} src={this.state.resList['442a4667-1ae0-43f7-b1f9-37a6cedf138f'].url} />
        <img className="sharebtn point6" onClick={() => { this.shareMsg() }} src={this.state.resList['73f4c449-b3e1-4797-90ce-438b9ba415de'].url} />
        <label className="shareMsgLab ">扫码许愿</label>
        <label className="backHomeBtn3 " src={resList['66eb7ce1-0581-438a-9798-d140f86623b3'].url} onClick={() => { this.returnHomeBtn() }} >退出</label>
        {modalType == MODAL_TYPE[MODAL_NAME.P_PRIZE_OPEN] && <OpenPrize></OpenPrize>}
        {/* {modalType == MODAL_TYPE[MODAL_NAME.P_PRIZE_RESULT] && <PrizePanel onClose={() => { this.modalControl() }} data={prizeData}></PrizePanel>} */}
        {modalType == MODAL_TYPE[MODAL_NAME.P_RULE] && <RuleModal rule={rule} onClose={() => { this.modalControl() }}></RuleModal>}
        {modalType == MODAL_TYPE[MODAL_NAME.P_PRIZE_CHECK] && <AwardModal jumpUrl={(url) => { this.jumpUrl(url) }} onClose={() => { this.modalControl() }}></AwardModal>}
      </div>
    );
  }
}
export default Pageresultscene;
