export class Buried {
    appId;
    consumerId;
    oaId;

    /**
     * 初始化
     */
    static init() {
        // appId = window["appId"];
        // oaId = window["projectId"];
        this.appId = window.CFG.appID;
        this.oaId = window.CFG.projectId;
    }

    /**
     * 创建dpm埋点数据
     * @param {string} dpm 点击埋点
     * @param {string} dcm 曝光埋点
     * @param {string} embedDomain 埋点域名
     * @returns {{dpm: string; consumerId: number; domain: string; appId: number}}
     */
    static createExposure(dpm, dcm, embedDomain = '//embedlog.duiba.com.cn') {

        let dom
        dom = "1.0.0.0"

        const exposure = {
            dpm: dpm,
            dcm: dcm,
            //   dom: dom,
            appId: Buried.appId,
            domain: embedDomain
        };
        return exposure;
    }

    /**
     * dpm拼接
     * @param pageId 页面ID 
     * @param area 区域
     * @param dpm 埋点号
     * @returns {string}
     */
    static connectDpm(pageId, area, dpm) {
        return Buried.appId + '.' + pageId + '.' + area + '.' + dpm;
    }

    /**
     * dcm拼接
     * @param typeId 类型ID
     * @param contentInfo 内容信息
     * @param dcm 埋点号
     * @returns {string}
     */
    static connectDcm(typeId, contentInfo, dcm) {
        return typeId + '.' + Buried.oaId + '.' + contentInfo + '.' + dcm;
    }

    /**
     * 插件dcm拼接
     * @param plugId 插件ID
     * @param type 1 活动工具 2 主会场 4 楼层 5 游戏 7 子页面
     * @returns {string}
     */
    static connectPlugDcm(plugId, type) {
        return 212 + '.' + plugId + '.' + type + '.' + Buried.oaId;
    }

    /**
     * 活动dcm拼接
     * @param type 1 活动工具 2 主会场 4 楼层 5 游戏 7 子页面
     * @returns {string}
     */
    static connectActivityDcm(type) {
        return 202 + '.' + Buried.oaId + '.' + type + '.' + Buried.oaId;
    }

}
