export const ModalImage = {
    NO_STOCK: "9b80be59-4fa3-4f6a-b629-2debba82ac8c",
    VIP_CHECK: "c9af4a2c-f766-48f8-b3bb-840d8bb2ae22",
    W1: "42783179-c885-470c-9eae-6b59493f2986",
    W2: "f16d3f74-51d1-4c29-aaa2-ec78963483a1",
    W3: "40ed1f27-265b-4bc8-84f4-91780e389a98",
    NOTIMES_IMG: "b97d2668-3e0a-481e-8df8-aa2f532b1fbc",
    END_IMG: "5ce85621-f1aa-41c7-993f-80f41d2ff9ff",
    NOT_START: "0d308df7-2e36-4484-9fb9-5abe50d80bbf"
}


export const JUMP_URL = {
    COUPON: 'https://file.10010sh.cn/member-center-v3/tickets',
    AD_URL: 'https://file.10010sh.cn/member-center-v3/sign-in'
}

export const MODAL_TYPE = {
    NO_STOCK: 1,
    VIP_CHECK: 2,
    W1_PRIZE: 3,
    W2_PRIZE: 4,
    W3_PRIZE: 5,
    NO_TIMES: 6,
    END: 7,
    NOT_START: 8,
    NOT_READY: 9,
    NO_WEEK_TIMES: 10
}

export const PRIZE_TYPE = {
    W1: "ru_1",
    W2: "ru_2",
    W3: "ru_3"
}

export const CURRENT_LEVEL = {
    level1: "W1",
    level2: "W2",
    level3: "W3"
}

export function Modal_Lables(modalType, level, openStatus) {
    let title = "";
    let desc = "";
    let content = "";
    let img = "";
    let prize = 0;



    // 未中奖title
    if ([1, 2, 6, 7, 8, 9, 10].includes(modalType)) {
        title = "很抱歉"
    } else {
        title = "恭喜您"
    }
    //没有库存的限制
    if (modalType == MODAL_TYPE.NO_STOCK) {
        desc = "券已领完";
        content = "下次早点来哦";
        img = ModalImage.NO_STOCK;
    }
    //未到达VIP等级弹窗展示
    if (modalType == MODAL_TYPE.VIP_CHECK) {
        desc = `您暂时还不是${level}用户`;
        content = "暂时无法领取代金券";
        img = ModalImage.VIP_CHECK;
    }
    if (modalType == MODAL_TYPE.NOT_START) {
        desc = "还没到活动时间哦";
        content = "周三10点再来试试吧";
        img = ModalImage.NOT_START;
    }
    if (modalType == MODAL_TYPE.NO_WEEK_TIMES) {
        desc = "本周可领取次数已用完";
        content = "下周再来哦";
        img = ModalImage.NOTIMES_IMG;
    }
    if (modalType == MODAL_TYPE.NO_TIMES) {
        desc = "本月可领取次数已用完";
        content = "下个月再来哦";
        img = ModalImage.NOTIMES_IMG;
    }
    if (modalType == MODAL_TYPE.END) {
        desc = "活动已结束";
        content = "下次再来吧";
        img = ModalImage.END_IMG;
    }
    console.log('level===', level, 'openStatus====', openStatus);

    if (openStatus == 1) {
        if ([MODAL_TYPE.W1_PRIZE, MODAL_TYPE.W2_PRIZE, MODAL_TYPE.W3_PRIZE].includes(modalType)) {
            content = "可前往“我的奖品”查看";
            prize = 1;
            img = ModalImage[level];
        }
        if (modalType == MODAL_TYPE.W1_PRIZE) {
            desc = '已领取流量日包券一张';
        }
        if (modalType == MODAL_TYPE.W2_PRIZE) {
            desc = '已领取5元无门槛代金券一张';
        }
        if (modalType == MODAL_TYPE.W3_PRIZE) {
            desc = '已领取10元无门槛代金券一张';
        }
    } else {
        if (modalType == MODAL_TYPE.NOT_READY) {
            title = "温馨提示";
            img = ModalImage.NO_STOCK;
            desc = "";
        }
        if (level == CURRENT_LEVEL.level1) {
            content = '由于系统原因,3GB全国流量日包券暂停发放';
        }
        if (level == CURRENT_LEVEL.level2) {
            content = '由于系统原因,5元无门槛代金券暂停发放';
        }
        if (level == CURRENT_LEVEL.level3) {
            content = '由于系统原因,10元无门槛代金券暂停发放';
        }
    }
    console.log("======", {
        title,
        desc,
        content,
        img,
        prize
    });
    return {
        title,
        desc,
        content,
        img,
        prize
    }
}

//错误码
export function ERROR_MESSSAGE(errorCode) {
    let message = "";
    switch (errorCode) {
        case "600001":
            message = "网络繁忙,请稍后重试";
            break;
        case "600002":
            message = "参数异常";
            break;
        // case 600003:
        //     message = "活动未开始";
        //     break;
        // case 600004:
        //     message = "会员等级不足";
        //     break;
        case "600005":
            message = "仅限上海联通用户参与";
            break;
        // case 600006:
        //     message = "库存不足";
        //     break;
        // case 600007:
        //     message = "本周已领取";
        //     break;
        // case 600008:
        //     message = "活动已结束";
        //     break;
        case "600011":
            message = "您不符合领取的条件哦～";
            break;
        default:
            message = "网络故障";
            break;
    }
    console.log("message===", message);
    return message;
}

export function ERROR_TYPE(errorCode) {
    if (["600003", "600004", "600006", "600007", "600008", "600009", "600010"].includes(errorCode)) {
        return false;
    } else {
        return true;
    }
}

export function ERROR_MODAL(errorCode) {
    let type = "";
    switch (errorCode) {
        case "600003":
            type = MODAL_TYPE.NOT_START;
            break;
        case "600004":
            type = MODAL_TYPE.VIP_CHECK;
            break;
        // case 600005:
        //     type = "仅限上海联通用户参与";
        //     break;
        case "600006":
            type = MODAL_TYPE.NO_STOCK;
            break;
        case "600007":
            type = MODAL_TYPE.NO_WEEK_TIMES;
            break;
        case "600008":
            type = MODAL_TYPE.END;
            break;
        case "600009":
            type = MODAL_TYPE.NO_TIMES;
            break;
        case "600010":
            type = MODAL_TYPE.NOT_READY;
            break;
        default:
            type = "网络故障";
            break;
    }
    console.log("modalType-----", type);
    return type;
}