'use strict';

import React, { Component } from 'react';
import resList from '../../resconfig/resList';
import { Toast, Loading, getModalHoc } from '../../../node_modules/spark-design';
import API from '../../api';
import { getPxToken } from '../../libs/spark_gettoken';
import verbModal from '../../components/commessagemodal/commessagemodal.jsx';
import ruleModal from '../../components/comrule/comrule.jsx';
import { MODAL_TYPE, Modal_Lables, ERROR_MESSSAGE, PRIZE_TYPE, ERROR_MODAL, CURRENT_LEVEL, ERROR_TYPE, JUMP_URL } from '../../constant';
import './pageweekverb.less';
const VerbModal = getModalHoc(verbModal);
const RuleModal = getModalHoc(ruleModal);
class Pageweekverb extends Component {
  constructor(props) {
    super(props);
    this.state = {
      resList: resList,
      modalStatus: "",
      baseData: {
        vipLevel: "",
        adUrl: "",
        adMes: "",
        tenDjStock: "",
        fiveDjStock: "",
        llbStock: ""
      },
      prizeObj: {
        W1: "",
        W2: "",
        W3: ""
      },
      modalData: {},
      pass: true,
      rule: ""
    };
  }

  componentDidMount() {
    this.getBaseInfoData();
  }


  submit() {
    if (this.state.pass) {
      this.setState({
        pass: false
      })
      setTimeout(() => {
        // pass = true;
        this.setState({
          pass: true
        })
      }, 1000);
    }
  }
  jumpUrl(url) {
    if (this.state.pass) {
      this.submit();
      if (url) {
        console.log("url===", url);
        window.location.href = url;
      }
      else {
        Toast('网络出现故障,请重试')
      }
    }
  }

  async getActivityRule() {
    let { data, success, code, message } = await API.getRule();
    console.log('data=', data);
    if (success) {
      this.setState({
        modalStatus: 2,
        rule: data
      })
    } else {
      Toast('获取规则信息失败');
    }
  }


  /**
   * 基础接口数据调用
   */
  async getBaseInfoData() {
    /*
      "data": {
      "vipLevel": "w2",
      "adUrl": "1",
      "adMes": "1",
      "tenDjStock": 1200,
      "fiveDjStock": 2000,
      "llbStock": 3000,
      llbStatus fiveDjStatus tenDjStatus
    },
    */
    console.log('======');
    let { success, data, code, message } = await API.getBaseInfo();
    console.log("data====", data);
    if (success) {
      this.setState({
        baseData: data,
        prizeObj: {
          ...this.state.prizeObj,
          W1: data.llbStock,
          W2: data.fiveDjStock,
          W3: data.tenDjStock,
        }
      })
      console.log('当前的奖品剩余数量===', this.state.prizeObj);
    } else {
      Toast("网络异常");
    }
  }
  /**
   * 领取奖品调用接口
   * @param {*} prizeType 
   */
  verbPrizeInterface(prizeType, modalType, level, openStatus) {
    console.log('openStatus=', openStatus, "modalType=", modalType, "level", level);
    let { prizeObj } = this.state;
    let leftStock = prizeObj[level];
    console.log('当前奖品剩余', leftStock);
    if (openStatus == 1) {
      if (leftStock > 0) {
        if (this.state.pass) {
          this.submit();
          getPxToken(
            async token => {
              let { success, message, code } = await API.verbPrize({ token: token, awardType: prizeType });
              console.log("success====", success, "message-====", message);
              if (success) {
                console.log('领取奖品结束', modalType);
                let modalInfo = Modal_Lables(modalType, level, openStatus);
                // modalInfo.prize = 1;
                this.getBaseInfoData();
                this.setState({
                  modalStatus: 1,
                  modalData: modalInfo
                })
              } else {
                console.log('>>>>>', ERROR_MESSSAGE(code));
                let isToast = ERROR_TYPE(code);
                if (isToast) {
                  Toast(ERROR_MESSSAGE(code));
                } else {
                  this.errorModal(code, level, openStatus);
                }
              }
            }
          )
        }
      }
      else {
        Toast('库存不足哦, 请下周再来~');
        // if (leftStock != 0) {
        //   this.getBaseInfoData();
        // }
      }
    } else {
      modalType = MODAL_TYPE.NOT_READY;
      console.log('modalType===', modalType, 'level===', level, 'openStatus===', openStatus);
      let modalInfo = Modal_Lables(modalType, level, openStatus);
      console.log('modalInfo-------打开弹窗', modalInfo);
      this.setState({
        modalStatus: 1,
        modalData: modalInfo
      })
    }
  }
  /**
   * 打开错误信息的弹窗
   * @param {*} errorCode 
   * @param {*} level 
   */
  errorModal(errorCode, level, openStatus) {
    console.log("打开弹窗");
    let modalType = ERROR_MODAL(errorCode);
    let modalInfo = Modal_Lables(modalType, level, openStatus);
    this.setState({
      modalStatus: 1,
      modalData: modalInfo
    });
  }

  render() {
    let { baseData, modalStatus, modalData, rule } = this.state;
    return (
      <div className="weekverb ">
        <img className="wholebg " src={this.state.resList['8c8463a4-658c-431f-ba5b-0fb00f4fda44'].url} />
        <img className="rulebtn " onClick={() => { this.getActivityRule() }} src={this.state.resList['02e17058-ddd8-41b5-8caf-e7680f723bcd'].url} />
        <div className="rewards ">
          <img className="rewardb " src={this.state.resList['7e5493cb-cbc9-4ddb-bb42-17d2e839e29a'].url} />
          <div className="w1rewar ">
            <img className="w1bg " src={this.state.resList['86fa1e7e-97b5-4d2d-9b73-42c629ec7c8e'].url} />
            <span className="w1limit ">W1会员及以上</span>
            <span className="w1stock ">剩余{baseData.llbStock || 0}份</span>
            <img className="w1verb point1" onClick={() => { this.verbPrizeInterface(PRIZE_TYPE.W1, MODAL_TYPE.W1_PRIZE, CURRENT_LEVEL.level1, baseData.llbStatus) }} src={this.state.resList['1f277473-a3c7-4f2a-a473-907c1d7428eb'].url} />
          </div>
          <div className="w2rewar ">
            <img className="w2bg " src={this.state.resList['fd31ffa9-c0ab-4f93-b894-c7ff817e1f30'].url} />
            <span className="w2limit ">W2会员专享</span>
            <span className="w2stock ">剩余{baseData.fiveDjStock || 0}份</span>
            <img className="w2verb point2" onClick={() => { this.verbPrizeInterface(PRIZE_TYPE.W2, MODAL_TYPE.W2_PRIZE, CURRENT_LEVEL.level2, baseData.fiveDjStatus) }} src={this.state.resList['1f277473-a3c7-4f2a-a473-907c1d7428eb'].url} />
          </div>
          <div className="w3rewar ">
            <img className="w3bg " src={this.state.resList['23116b8a-cbb7-4a44-a1f8-bbb7b23a8392'].url} />
            <span className="w3limit ">W3及以上会员专享</span>
            <span className="w3stock ">剩余{baseData.tenDjStock || 0}份</span>
            <img className="w3verb point3" onClick={() => { this.verbPrizeInterface(PRIZE_TYPE.W3, MODAL_TYPE.W3_PRIZE, CURRENT_LEVEL.level3, baseData.tenDjStatus) }} src={this.state.resList['1f277473-a3c7-4f2a-a473-907c1d7428eb'].url} />
          </div>
          <img className="myrewar " onClick={() => { this.jumpUrl(JUMP_URL.COUPON) }} src={this.state.resList['b1f11e37-165a-4bfa-8058-ceddecb14ba2'].url} />
          {/* <img className="adborde " src={this.state.resList['d45b8c4a-1eaa-436c-b992-cca999839d66'].url} /> */}
          <img className="adimg point4" onClick={() => { this.jumpUrl(baseData.adUrl) }} src={this.state.resList['f2366ce5-dc77-4941-a8bf-48f35b4e0536'].url} />
          <span className="adslot ">广告位</span>
        </div>

        {modalStatus == 1 && <VerbModal data={modalData} onClose={() => { this.setState({ modalStatus: 0 }) }}></VerbModal>}
        {modalStatus == 2 && <RuleModal rule={rule} onClose={() => { this.setState({ modalStatus: 0 }) }} ></RuleModal>}
      </div>
    );
  }
}
export default Pageweekverb;
