/**
 * 截图方法封装
 * 
 * 
 * 使用方法： npm install --save html2canvas
 * 
 * 
 * import { createrPoster } from '../../libs/spark_createposter';
  async createPoster()
  {
    let url = await createPoster("rule",{
      x:window.innerWidth/4,
      y:window.innerHeight/4,
      width:window.innerWidth/2,
      height:window.innerHeight/2
    });
    this.setState({
      img_src:url
    })
  }
  调用：this.createPoster();

  jsx: 
  const {img_src=""} = this.state;
  {img_src && <img src={img_src} style={{ width: '50vw', height: '50vw', position: "absolute", left: 0, top: 0 }} />}
  
 * 
 * 
 * 注意事项：html2canvas有各种兼容问题
 * 1：html2canvas 使用 1.0.0-rc.5 版本， ios 设备上会没有任何显示。then函数不会被回调也不会报错。请降级强制使用 1.0.0-rc.4 版本。（注意package.json 内的 "^1.0.0-rc.4" ^ 符号要去掉）
 * 2：所有 dom 内的图片不能跨域，否则会导致白屏等奇怪问题。即使加上useCORS 与 allowTaint也无法解决，浏览器控制台直接会打印CORS相关报错。
 * 3：生成的图片清晰度受原始图片的质量与width、height、windowWidth、windowHeight、scale 影响，请根据实际情况来调节这几个参数。
 * 4：如果生成的base64图片过大，会导致图片无法显示，请相应减小3中的几个参数值。
 * 5：不可将图片转换为Blob的形式，设备虽然可以正常显示图片，但是无法进行长按保存，保存下来的图片可能为一个空白的图像。
 * 6：在指定dom来生成图片时，会受offsetTop与offsetLeft影响。例如 offsetTop 为 20 时，生成的图片顶部 20px(不一定为 20px)的距离会被所设置的backgroundColor(默认白色)颜色填充。这时，可使用 x与y参数进行校正。
 * 7：如果一直出现跨域的情况，或者图片一直不出现的情况，可考虑将图片资源转换成 base64。例如就遇到二维码图片链接某些设备上一直不出现，则可以考虑接口直接返回二维码内容，由前端根据返回的内容来创建二维码。
 * 8：当还出现一些奇奇怪怪的问题时，可尝试切换html2canvas版本。
 */



import  html2Canvas  from 'html2canvas';

/**
 * 
 * @param {*} domId dom的id名，不传默认是body
 * @param {*} options 重写的截图配置，具体参考html2canvas官方示例:http://html2canvas.hertzen.com/configuration
 * @param {*} imgType 图片类型，默认是jpg
 */
const createPoster=async (domId,options={},imgType="image/jpeg")=>{
    let dom = domId?document.getElementById(domId):document.body;
    let defaultOptions={
        useCORS:true,
        scale:devicePixelRatio||1,
        width:window.innerWidth,
        height:window.innerHeight,
        windowWidth:window.innerWidth,
        windowHeight:window.innerHeight
    }
    options={
        ...defaultOptions,
        ...options
    }
    let canvas = await html2Canvas(dom,options).catch(err=>{console.error("截图失败:",err)})
    return canvas.toDataURL(imgType);
}
export default createPoster;