import Qs from "qs";
import axios from "axios";
// 分享召回工具类
import { isFromShare, newUser } from 'duiba-utils';
let mergeData = {
  user_type: newUser ? '0' : '1',
  is_from_share: isFromShare ? '0' : '1',
  _t: Date.now()
}

const TIMEOUT = 10000;

const instance = axios.create({
  timeout: TIMEOUT, // 请求超时时间
});

instance.interceptors.request.use(
  (config) => {
    if (config.method === "get") {
      config.data = true;
    }
    config.method === "post"
    ? (config.data = Qs.stringify({ ...config.data, ...mergeData }))
    : (config.params = { ...config.params, ...mergeData });
    config.headers["Content-Type"] = "application/x-www-form-urlencoded";

    return config;
  },
  (error) => {
    //请求错误处理
    Promise.reject(error);
  }
);

// 响应拦截器
instance.interceptors.response.use(
  // 请求成功
  (res) => {
    const { status } = res || -1000;
    return (status >= 200 && status <= 400) ? res.data : res
  }
);

export default instance;
