'use strict';

import React, { Component } from 'react';
import resList from '../../resconfig/resList';
import API from '../../api';
import { TASK_TYPE, MODAL_TYPE, GET_TASK, TASK_STATUS } from '../../constant';
import { Toast, Loading, getModalHoc } from '../../../node_modules/spark-design';
import './pagemainsence.less';
import { getPxToken } from '../../libs/spark_gettoken';
import comLevelModal from '../../components/comlevelmodal/comlevelmodal.jsx';
import { NetBuried } from '../../NetBuried';


const LevelModal = getModalHoc(comLevelModal);
class Pagemainsence extends Component {
  constructor(props) {
    super(props);
    this.state = {
      resList: resList,
      userData: {
        exp: "",
        nextLevelExp: "",
        indexUrl: "",
        growthDetailsUrl: "",
        plusUrl: "",
        memberLevel: "",
        nextLevel: ""
      },
      curModalType: "",
      isDo: true,
      specialTasks: {
        unFinishNum: "",
        tasKVos: [],
      },
      dayTasks: {
        unFinishNum: "",
        tasKVos: [],
      },
      weekTasks: {
        unFinishNum: "",
        tasKVos: [],
      },
      monthTasks: {
        unFinishNum: "",
        tasKVos: [],
      }
    };
  }

  componentDidMount() {
    this.getUserData();
    this.getEachTaskList();
    console.log();
  }

  /**
   * 弹窗赋值
   * @param {*} type 
   */
  modalControl(value) {
    this.setState({
      curModalType: value
    })
    console.log("curModalType====", this.state.curModalType);
  }
  /**
   * 获取用户的基础信息
    "data": {
    "exp": "123",
    "nextLevelExp": "234",
    "indexUrl": "",
    "growthDetailsUrl": "",
    "plusUrl": "",
    "memberLevel": "",
    "nextLevel": ""
  },
   */
  async getUserData() {
    let { data, success, message } = await API.getUserBaseInfo();
    if (success) {
      this.setState({
        userData: data
      })
      this.curUserExpPosition("curpositionPic");
      console.log("获取用户信息", this.state.userData);
    } else {
      Toast(message);
    }
  }
  /**
    * 跳转链接
    * @param {*} url 
    */
  jumpUrl(url) {
    console.log('url---------', url);
    setTimeout(() => {
      this.setState({
        isDo: true
      })
    }, 2000)
    if (this.state.isDo) {
      this.setState({
        isDo: false
      })
      if (url) {
        // setTimeout(() => {
        window.location.href = url;
        // }, 500);
      } else {
        Toast("请检查网络");
      }
    }
  }
  /**
   * 获取用户的对应活动信息
   */
  async getEachTaskList() {
    Loading.show();
    let { data, message, success } = await API.getTaskList();
    if (success) {
      Loading.hide();
      this.setState({
        specialTasks: data[GET_TASK.speTask],
        dayTasks: data[GET_TASK.dayTask],
        weekTasks: data[GET_TASK.weekTask],
        monthTasks: data[GET_TASK.monthTask]
      })
      let { specialTasks, dayTasks, weekTasks, monthTasks } = this.state;
      let num = specialTasks.tasKVos.length + dayTasks.tasKVos.length + weekTasks.tasKVos.length + monthTasks.tasKVos.length;
      //5为初始前面的四个埋点
      for (let i = 5; i < num + 5; i++) {
        this.autoBuried(i);
      }

    } else {
      Toast(message)
    }
  }
  /**
   * 做任务
   * @param {*} item 
   * @param {*} type 
   */
  doTasks(item, type) {
    console.log("做任务!");
    let that = this;
    setTimeout(() => {
      that.setState({
        isDo: true
      })
    }, 2000)
    if (that.state.isDo) {
      that.setState({
        isDo: false
      })
      let { taskId, openTime, linkUrl } = item;
      if (openTime == 0 || that.curTaskOpenStatus(openTime)) {
        getPxToken(
          async token => {
            let { success, message } = await API.postDoTask({ token: token, taskId: taskId, taskType: type });
            console.log("success====", success, "message-====", message);
            if (success) {
              console.log('that====', that);
              that.jumpUrl(linkUrl);
              this.getEachTaskList();
              this.getUserData();
            } else {
              Toast(message);
            }
          }
        )
      } else {
        console.log("不在完成任务时间内");
        Toast("不在可完成任务时间内")
      }
    }
  }
  /**
   * 曝光埋点
   * @param {*} index 
   */
  autoBuried(index) {
    let buried = new NetBuried();
    buried.showLog(index);
  }
  /**
   * 点击埋点
   * @param {*} index 
   */
  handlerBuied(index) {
    let buried = new NetBuried();
    buried.clickLog(index);
  }

  /**
   * 当前用户的位置
   * @param {*} objId 
   */
  curUserExpPosition(objId) {
    console.log('》》》》》》', this.state.userData);
    console.log('>>>>>>>', document.getElementById(objId).style);
    let elementStyle = document.getElementById(objId).style;
    //left   x   5px=0  70px=2000  135px=6000  201px=15000  267px=25000   333px=50000
    //           0.01    0.183     0.36      0.535     0.71    0.888
    //top    y   145px=0 130px=2000  110px=6000 85px=15000  40px=25000    -15px=50000
    //           0.185    0.175     0.15     0.115    0.064    -0.01
    let left0 = this.getCurLeftTop(this.state.userData.exp).left;
    let top0 = this.getCurLeftTop(this.state.userData.exp).top;
    console.log("left0=====", left0 / 750, 'top0=====', top0);
    elementStyle.left = `${left0}%`;
    elementStyle.top = `${top0}%`;
    // elementStyle.left = `${(left0 / 750) * 100}%`;
    // elementStyle.top = `${top0}px`;
  }
  /**
   * 获取所处区间
   * @param {*} exp 
   */
  getCurLeftTop(exp) {
    let first = { left: 1, top: 18.5, num: 0 };
    let second = { left: 18.3, top: 17.5, num: 2000 };
    let third = { left: 36, top: 15, num: 6000 };
    let fouth = { left: 53.5, top: 11.5, num: 15000 };
    let fifth = { left: 71, top: 6.4, num: 25000 };
    let sixth = { left: 88.8, top: -1, num: 50000 }
    let result = {};
    if (+exp >= first.num && +exp < second.num) {
      result = this.getPositionDetail(+exp, first, second);
    } else if (+exp >= second.num && +exp < third.num) {
      result = this.getPositionDetail(+exp, second, third);
    } else if (+exp >= third.num && +exp < fouth.num) {
      result = this.getPositionDetail(+exp, third, fouth);
    } else if (+exp >= fouth.num && +exp < fifth.num) {
      result = this.getPositionDetail(+exp, fouth, fifth);
    } else if (+exp >= fifth.num && +exp <= sixth.num) {
      result = this.getPositionDetail(+exp, fifth, sixth);
    } else if (+exp > 50000) {
      result = { left: 90, top: -2 };
    }
    return result;
  }
  /**
   * 获取当前节点的坐标值
   * @param {*} exp 
   * @param {*} forward 
   * @param {*} behind 
   */
  getPositionDetail(exp, forward, behind) {
    console.log(forward, behind);
    let result = {};
    result.left = (+exp - forward.num) / (behind.num - forward.num)
      * (behind.left - forward.left)
      + forward.left;
    result.top = forward.top - (+exp - forward.num) / (behind.num - forward.num)
      * (forward.top - behind.top);
    console.log('result====', result);
    return result;
  }
  /**
   * 当前任务的开启状态
   * @param {*} openTime 
   */
  curTaskOpenStatus(openTime) {
    let curTime = (new Date()).getDate();
    // console.log('curTime====', curTime);
    return curTime == openTime;
  }
  /**
   * 
   * @param {*} item :{status:0 do , 1 did , -1 close}
   * openTime:(0 noLimit, 1-31 openDay)
   */
  taskCanDoStatus(item) {
    //无限制
    if (item.openTime == 0) {
      return item.status;
    }
    else if (item.openTime != 0) {
      if (this.curTaskOpenStatus(item.openTime)) {
        return item.status;
      }
      else {
        return TASK_STATUS.NO_YET;
      }
    }
  }
  render() {
    let { userData, curModalType, specialTasks, dayTasks, weekTasks, monthTasks } = this.state;
    console.log('specialTasks=', specialTasks, "dayTasks=", dayTasks, "weekTasks=", weekTasks, "monthTasks=", monthTasks);
    return (
      <div className="mainsence ">
        <img className="whitebg " src={this.state.resList['7d50eb57-26e5-43f8-8a29-85693e316212'].url} />
        <div className="lineshow ">
          <img className="linebg " src={this.state.resList['4df3976c-0c7b-4556-b7ae-494c7626dbea'].url} />
          <img className="lines " src={this.state.resList['4cd2c485-c9e6-40cd-87c9-fcec75a8fdc5'].url} />
          <img className="curposition " id="curpositionPic" src={this.state.resList['e0c38676-d8bc-4369-b31c-a88ebf972b64'].url} />
        </div>
        <img className="backHome" />
        <label className="backHomeLab point2" onClick={() => { this.jumpUrl(userData.indexUrl) }}>返回主页</label>
        <img className="growdbtn point1" onClick={() => { this.jumpUrl(userData.growthDetailsUrl) }} src={this.state.resList['5f9a8bc1-8eb7-49fd-9865-3a29221ef666'].url} />
        <div className="userdata ">
          <img className="data " src={this.state.resList['ffefebcb-42b7-49b1-8b8a-152239182bda'].url} />
          <span className="content ">太棒了，再加
            <label className="contentNum">{userData.nextLevelExp || ""}</label>
          点就能成</span>
          <img className="w3Bg" src={this.state.resList['719f3af1-4595-4616-98d0-b44060312c04'].url} />
          <span className="curlevel ">{userData.memberLevel || "W0"}</span>
          <span className="content2 ">升级后更多特权！</span>
          <img className="acbtn point3" onClick={() => { this.jumpUrl(userData.plusUrl); }} src={this.state.resList['025075be-eac0-486d-9e17-916c9acafaf9'].url} />
          <span className="exp ">{userData.exp || 0}</span>
        </div>
        <img className="centerline " src={this.state.resList['3d0198cc-546d-4634-a23c-a4623a945dcf'].url} />
        <div className="growguide ">
          <img className="growbg " src={this.state.resList['25b2fbbc-5b32-4e12-bc88-c50c95b1e5a4'].url} />
          <img className="growrightbtn point4" onClick={() => { console.log("打开等级介绍"); this.modalControl(MODAL_TYPE.levelMsg) }} src={this.state.resList['0eb44a8e-4ded-40e8-b839-bd0b817d8c86'].url} />
        </div>
        {/* 特殊任务list */}
        <div className="spectasks " style={{ height: specialTasks.tasKVos.length * 21.5 + 'vw' }}>
          <div className="spectitle ">
            <img
              className="yuan_jiao_ju_xing_28119 "
              src={this.state.resList['e86021b9-a478-468c-ad2e-906a4bac1325'].url}
            />
            <img className="tu_ceng_675 " src={this.state.resList['e9a15216-5b4f-4703-9f4d-1aea490be6a9'].url} />
            <span className="te_shu_ren_wu_137 ">特殊任务</span>
            <img className="tuo_yuan_67813 " src={this.state.resList['7cc4ebad-77bf-48f1-98b2-b448b87ad1f9'].url} />
          </div>
          <span className="speclast ">未完成 {specialTasks.unFinishNum}</span>
          <img className="specbg " style={{ height: specialTasks.tasKVos.length * 21.5 + 'vw' }} src={this.state.resList['d81bba07-4715-4a29-85d5-de882a162bda'].url} />
          {specialTasks.tasKVos && specialTasks.tasKVos.map((item, index) => {
            return (
              <div>
                {/* {index == 0 && <div className="forward"></div>} */}
                <div className="spec1task " key={index} >
                  <img className="spec1icon " src={item.icon} />
                  <div className="spec1 ">
                    <span className="spec12 ">{item.taskName}</span>
                    <span className="spec11 ">{item.desc}</span>
                    <img className="pic11 " src={this.state.resList['a5ec0fd6-0ba8-4693-84ef-2fffbcb63124'].url} />
                  </div>
                  {this.taskCanDoStatus(item) == TASK_STATUS.DONE && <img className="taskdone11 " src={this.state.resList['02cc4782-96aa-43b3-b7c0-884cf7fed4ec'].url} />}
                  {this.taskCanDoStatus(item) == TASK_STATUS.NO_YET && <img className={"dotask11 " + `special${index}`} onClick={() => { console.log("去做特殊任务"); this.doTasks(item, TASK_TYPE.special); this.handlerBuied(index + 5) }} src={this.state.resList['89009469-4242-424c-945f-11f71df8b74c'].url} />}
                  {this.taskCanDoStatus(item) == TASK_STATUS.CLOSE && <label className="noStart">敬请期待</label>}
                  {index < specialTasks.tasKVos.length - 1 && < div className="line11 " />}
                </div>
                {/* {this.taskCanDoStatus(item)} */}
              </div>
            )
          })}
        </div>
        {/* 每日任务list */}
        <div className="daytasks " style={{ height: dayTasks.tasKVos.length * 21 + 'vw' }}>
          <div className="daytitle ">
            <img className="bgday " src={this.state.resList['af38e4ff-934f-4580-b60a-efd8df9583b0'].url} />
            <img className="daypic " src={this.state.resList['4f7897cd-3621-4974-a36d-e231e53f2677'].url} />
            <span className="taskday ">每日任务</span>
            <img className="daypicc " src={this.state.resList['e2b25d6a-1449-4202-ba66-94b745e77f1a'].url} />
          </div>
          <span className="daylast ">未完成 {dayTasks.unFinishNum || ""}</span>
          <img className="daybg " style={{ height: dayTasks.tasKVos.length * 21 + 'vw' }} src={this.state.resList['6c3ddc67-4d84-4a47-9689-2381185cd63f'].url} />
          {
            dayTasks.tasKVos && dayTasks.tasKVos.map((item, index) => {
              return (
                <div>
                  {/* {index == 0 && <div className="forward"></div>} */}
                  <div className="daytask1 " key={index}>
                    <img className="day1icon " src={item.icon || ""} />
                    <div className="day1 ">
                      <span className="day12 ">{item.taskName}</span>
                      <span className="day11 ">{item.desc}</span>
                      <img className="pic21 " src={this.state.resList['a5ec0fd6-0ba8-4693-84ef-2fffbcb63124'].url} />
                    </div>
                    {this.taskCanDoStatus(item) == TASK_STATUS.DONE && <img className="taskdone21 " src={this.state.resList['70a97f42-bdfa-4593-9e33-cab25368967a'].url} />}
                    {this.taskCanDoStatus(item) == TASK_STATUS.NO_YET && <img className={"dontask21 " + `day${index}`} onClick={() => { this.doTasks(item, TASK_TYPE.day); this.handlerBuied(index + 5 + specialTasks.tasKVos.length) }} src={this.state.resList['ff460a05-4d3b-47f4-b956-be36bd54e5d3'].url} />}
                    {this.taskCanDoStatus(item) == TASK_STATUS.CLOSE && <label className="noStart">敬请期待</label>}
                    {index < dayTasks.tasKVos.length - 1 && < div className="line34 " />}
                  </div>
                  {/* {this.taskCanDoStatus(item)} */}
                </div>
              )
            })
          }
        </div>
        {/* 每周任务 */}
        <div className="weektasks " style={{ height: weekTasks.tasKVos.length * 21 + 'vw' }}>
          <img className="weektitle " src={this.state.resList['23fc67e9-3913-4f39-a25c-adfbccad8100'].url} />
          <span className="weeklast ">未完成 {weekTasks.unFinishNum || ""}</span>
          <img className="weekbg " style={{ height: weekTasks.tasKVos.length * 21 + 'vw' }} src={this.state.resList['667af9a0-f0db-4f67-9752-a1aa7aa7784d'].url} />
          {
            weekTasks.tasKVos && weekTasks.tasKVos.map((item, index) => {
              return (
                <div>
                  {/* {index == 0 && <div className="forward"></div>} */}
                  <div className="weektask1 " key={index}>
                    <img className="week1icon " src={item.icon || ""} />
                    <div className="week1 ">
                      <span className="week34 ">{item.taskName || ""}</span>
                      <span className="week33 ">{item.desc || ""}</span>
                      <img className="pic31 " src={this.state.resList['a5ec0fd6-0ba8-4693-84ef-2fffbcb63124'].url} />
                    </div>
                    {this.taskCanDoStatus(item) == TASK_STATUS.DONE && <img className="taskdone31 " src={this.state.resList['6ff585bc-43b4-4d4e-931a-b0b9d472c67f'].url} />}
                    {this.taskCanDoStatus(item) == TASK_STATUS.NO_YET && <img className={"dotask31 " + `week${index}`} onClick={() => { console.log("去做每周任务"); this.handlerBuied(index + 5 + specialTasks.tasKVos.length + dayTasks.tasKVos.length); this.doTasks(item, TASK_TYPE.week) }} src={this.state.resList['ff460a05-4d3b-47f4-b956-be36bd54e5d3'].url} />}
                    {this.taskCanDoStatus(item) == TASK_STATUS.CLOSE && <label className="noStart">敬请期待</label>}
                    {index < weekTasks.tasKVos.length - 1 && <div className="line23 " />}
                  </div>
                  {/* {this.taskCanDoStatus(item)} */}
                </div>
              )
            })
          }
        </div>
        {/* 每月任务 */}
        <div className="monthtasks " style={{ height: monthTasks.tasKVos.length * 19 + 'vw' }}>
          <span className="monthlast ">未完成 {monthTasks.unFinishNum || ""}</span>
          <img className="month " src={this.state.resList['55bb7dce-3497-42d9-92a5-aaf3da66e21e'].url} />
          <img className="monthbg " style={{ height: monthTasks.tasKVos.length * 19 + 'vw' }} src={this.state.resList['36dd7f9c-ab84-4099-87bd-cc62aa765f6d'].url} />
          {
            monthTasks.tasKVos && monthTasks.tasKVos.map((item, index) => {
              return (
                <div>
                  {/* {index == 0 && <div className="forward"></div>} */}
                  <div className="month4task1 " key={index}>
                    <img className="month0icon " src={item.icon || ""} />
                    <div className="month0 ">
                      <span className="month02 ">{item.taskName}</span>
                      <span className="month01 ">{item.desc}</span>
                      <img className="pic0 " src={this.state.resList['a5ec0fd6-0ba8-4693-84ef-2fffbcb63124'].url} />
                    </div>
                    {this.taskCanDoStatus(item) == TASK_STATUS.NO_YET && <img className={"dotask41 " + `month${index}`} onClick={() => { console.log("去做每月任务"); this.handlerBuied(index + 5 + specialTasks.tasKVos.length + dayTasks.tasKVos.length + weekTasks.tasKVos.length); this.doTasks(item, TASK_TYPE.month) }} src={this.state.resList['01b0e85e-c78c-4260-8cbf-0bdd8fc85ad0'].url} />}
                    {this.taskCanDoStatus(item) == TASK_STATUS.DONE && <img className="taskdone41 " src={this.state.resList['6ff585bc-43b4-4d4e-931a-b0b9d472c67f'].url} />}
                    {this.taskCanDoStatus(item) == TASK_STATUS.CLOSE && <label className="noStart">敬请期待</label>}
                    {index < monthTasks.tasKVos.length - 1 && <div className="line13 " />}
                  </div>
                  {/* {this.taskCanDoStatus(item)} */}
                </div>
              )
            })
          }
        </div>
        {/* <img className="btn " src={this.state.resList['111335cb-14e8-46d8-a227-375c8ddc6ad0'].url} />
        <div className="bottomline " /> */}
        <img className="plusicon " src={this.state.resList['0470c110-c0a4-4ef6-b660-aeccc93aea3c'].url} />
        { curModalType == MODAL_TYPE.levelMsg && <LevelModal onClose={() => { this.modalControl() }} ></LevelModal>}
      </div>
    );
  }
}
export default Pagemainsence;
