import showLog from "../../new_tw/ctrls/showLog";
import { LotteryType } from "../../tw/enum/LotteryType";
import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";
import Panel from "./Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
export default class NoPrizePanel extends Panel {
    get skinKey() { return 'NoPrize' }

    start(data) {
        this.data = data;
        this.scoreTxt.text = `${this.data && this.data.score ? this.data.score : 0}`;
        NetManager.ins.getInfo();
    }

    public closeBtn:eui.Button;
    public againBtn:eui.Button;
    public scoreTxt:eui.Label;

    initEvents() {
        super.initEvents();
        this.againBtn.once(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this);
        this.closeBtn.once(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
    }

    onTap_againBtn():any{
    }

    onTap_closeBtn(): any {
        super.onTouchTap_closeBtn();
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }

    protected get closeBtns(): eui.Button[] {
        return [this['closeBtn']]
    }
}