export default class Kids extends egret.Sprite {
    constructor() {
        super();
        this.y = 710;
        this.createBg();
    }

    private boyhand: egret.Bitmap;
    private girlhand: egret.Bitmap;
    async createBg() {
        const picData: egret.SpriteSheet = await RES.getResAsync('kids_json');
        this.addPic(picData, 'kidschair', 0, 160);
        this.boyhand = this.addPic(picData, 'boyhand', 90, 137);
        this.girlhand = this.addPic(picData, 'girlhand', 658, 138, 79, 0);
        this.addPic(picData, 'kids');
        this.addAnimation(picData.getTexture('boy_eye'), 122, 109);
        this.addAnimation(picData.getTexture('girl_eye'), 622, 111);
        egret.Tween.get(this).set({ alpha: 0 }).to({ alpha: 1 }, 200);
    }

    doAction() {
        const speed = 200;
        egret.Tween.get(this.boyhand).to({ rotation: -50 }, speed).to({ rotation: 0 }, speed);
        egret.Tween.get(this.girlhand).to({ rotation: 50 }, speed).to({ rotation: 0 }, speed);
    }

    addPic(picData: egret.SpriteSheet, key: string, x = 0, y = 0, anchorOffsetX = 0, anchorOffsetY = 0) {
        const pic = new egret.Bitmap(picData.getTexture(key));
        pic.anchorOffsetX = anchorOffsetX;
        pic.anchorOffsetY = anchorOffsetY;
        pic.x = x;
        pic.y = y;
        this.addChild(pic);
        return pic;
    }

    addAnimation(texture: egret.Texture, x: number, y: number) {
        const pic = new egret.Bitmap(texture);
        this.addChild(pic);
        pic.anchorOffsetX = texture.textureWidth >> 1;
        pic.anchorOffsetY = texture.textureHeight >> 1;
        pic.x = x;
        pic.y = y;
        egret.Tween.get(pic, { loop: true })
            .to({ scaleY: 0 }, 200)
            .to({ scaleY: 1 }, 200).wait(3000);
    }
}