/**
 *Created by ck on 2018/5/2
 */
// import { IData } from "../../../../tc/interface/IData";
import { Data } from "../Data";
import { GetHomeInfoData } from "./GetHomeInfoData";

export class PetsIndexData extends Data {
    /**
     * 积分
     */
    public credits: number;

    /**
     * 积分单位	
     */
    public creditsUnitName: string;

    /**
     * 用户uid
     */
    public uid: string;

    /**
     * appId
     */
    public appId: number;

    /**
     * 是否未登录
     */
    public notLogin: boolean;

    /**
     * 用户id（未登录时为空）
     */
    public consumerId:number;

    /**
     * 商品域名
     */
    public goodsDomain:string;

    /**
     * 楼层域名
     */
    public homeDomain:string;

    /**
     * 埋点域名
     */
    public embedDomain:string;

    /**
     * 用户自定义参数
     */
    public dcustom:object = {};

    /**
     * 活动id
     */
    public activityId:number;

    public update(result: any): void {
        if(!result) {
            return;
        }
        this.credits = result.credits;
        this.creditsUnitName = result.creditsUnitName;
        this.uid = result.uid;
        this.appId = result.appId;
        this.notLogin = result.notLogin;
        this.goodsDomain = result.goodsDomain;
        this.homeDomain = result.homeDomain;
        this.embedDomain = result.embedDomain;
        this.dcustom = result.dcustom;
        this.activityId = result.activityId;
        this.consumerId = result.consumerId;
    }
}