import StartScene from "./StartScene";

export default (that: StartScene) => {

    const createShape = () => {
        const shape = new egret.Shape();
        shape.graphics.beginFill(0, .6);
        shape.graphics.drawCircle(0, 0, that['leftBtn'].width / 2);
        shape.graphics.endFill();
        shape.anchorOffsetX = -that['leftBtn'].width / 2;
        shape.anchorOffsetY = -that['leftBtn'].width / 2;
        return shape
    }

    [that['leftBtn'], that['rightBtn']].forEach(btn => {
        btn.addEventListener(egret.TouchEvent.TOUCH_BEGIN, (e: egret.TouchEvent) => {
            const btn = e.currentTarget;
            const shape = btn.maskShape;
            egret.Tween.removeTweens(shape);
            egret.Tween.get(shape).to({ alpha: 0 }, 200);
        }, that);
    });

    [that['leftBtn'], that['rightBtn']].forEach(btn => {
        btn.addEventListener(egret.TouchEvent.TOUCH_END, (e: egret.TouchEvent) => {
            const btn = e.currentTarget;
            const shape = btn.maskShape;
            egret.Tween.removeTweens(shape);
            egret.Tween.get(shape).to({ alpha: 1 }, 200);
        }, that);
    });

    [that['leftBtn'], that['rightBtn']].forEach(btn => {
        btn.addEventListener(egret.TouchEvent.TOUCH_RELEASE_OUTSIDE, (e: egret.TouchEvent) => {
            const btn = e.currentTarget;
            const shape = btn.maskShape;
            egret.Tween.removeTweens(shape);
            egret.Tween.get(shape).to({ alpha: 1 }, 200);
        }, that);
    });

    // this['rightBtn'];
    const shapeLeft = createShape();
    that.addChild(shapeLeft);
    shapeLeft.x = that['leftBtn'].x;
    shapeLeft.y = that['leftBtn'].y;
    that['leftBtn'].maskShape = shapeLeft;

    const shapeR = createShape();
    that.addChild(shapeR);
    shapeR.x = that['rightBtn'].x;
    shapeR.y = that['rightBtn'].y;
    that['rightBtn'].maskShape = shapeR;
}

