import getIsIOS from "../../new_tc/getIsIOS";
import wait from "../../new_tc/wait";
import doStart from "../../new_tw/ctrls/doStart";
import getCountTxt from "../../new_tw/datas/getCountTxt";
import getStartBtnEnable from "../../new_tw/datas/getStartBtnEnable";
import { DataManager } from "../../tw/manager/DataManager";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import Scene from "./Scene";

export default class StartSceneBase extends Scene {
    ruleBtn: eui.Button;
    htmlRuleBtn: eui.Button;
    optionBtn: eui.Button;
    recordBtn: eui.Button;
    startBtn: eui.Button;
    rankBtn: eui.Button;
    elements: eui.Group;

    countTxt: eui.Label;
    exemptionTxt: eui.Label;

    async start(data?) {
        this.startBtn.visible = false;
        this.updateGetInfoView();
        this.updateExemptionTxt();
        super.start();
    }

    async playAnimation() {
        this.startBtn.horizontalCenter = 750;
        this.countTxt.horizontalCenter = 750;
        const btns = [this.ruleBtn, this.optionBtn, this.recordBtn, this.rankBtn];
        btns.forEach(btn => btn.alpha = 0)

        await wait(400);
        egret.Tween.get(this.startBtn).to({ horizontalCenter: 0 }, 300, egret.Ease.backOut);
        egret.Tween.get(this.countTxt).wait(100).to({ horizontalCenter: 0 }, 300, egret.Ease.backOut);
        btns.forEach(btn => {
            egret.Tween.get(btn).to({ alpha: 1 }, 700, egret.Ease.backOut);
        });
        await wait(500);
        egret.Tween.get(this.startBtn, { loop: true })
            .to({ scaleY: 1.1, scaleX: 0.9 }, 1000, egret.Ease.bounceOut)
            .wait(500)
            .to({ scaleY: 1, scaleX: 1 }, 1000)
            .to({ scaleX: 1.1, scaleY: 0.9 }, 1000)
            .to({ scaleX: 1, scaleY: 1 }, 1000);
    }

    private updateGetInfoView() {
        if (DataManager.ins.getInfoData) {
            this.updateStartBtnStatus();
            this.updateCountTxt();
        } else {
            DataManager.ins.once('dataUpdate', this.updateGetInfoView, this);
        }
    }

    async updateStartBtnStatus() {
        if (this.startBtn) {
            this.startBtn.visible = true;
            this.startBtn.enabled = getStartBtnEnable();

        }
    }

    updateCountTxt() {
        if (this.countTxt) {
            this.countTxt.text = getCountTxt();

        }
    }

    updateExemptionTxt() {
        if (this.exemptionTxt) {
            if (getIsIOS()) {
                this.exemptionTxt.visible = true;
            } else {
                this.exemptionTxt.visible = false;
            }
        }
    }

    initEvents() {
        if (this.ruleBtn)
            this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        if (this.htmlRuleBtn)
            this.htmlRuleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_htmlRuleBtn, this);
        if (this.optionBtn)
            this.optionBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_optionBtn, this);
        if (this.recordBtn)
            this.recordBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this);
        if (this.startBtn)
            this.startBtn.once(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
        if (this.rankBtn)
            this.rankBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rankBtn, this);
    }

    onTap_ruleBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
    }
    onTap_htmlRuleBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.HTML_RULE_PANEL);
    }

    onTap_optionBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.OPTIONS_PANEL);
    }

    onTap_recordBtn(e: egret.Event) {
    }

    async onTap_startBtn(e?: egret.Event) {
        egret.Tween.removeTweens(this.startBtn);
        doStart();

        egret.Tween.get(this.startBtn).to({ horizontalCenter: -750 }, 300);
        egret.Tween.get(this.countTxt).to({ horizontalCenter: -750 }, 300);
        const btns = [this.ruleBtn, this.optionBtn, this.recordBtn, this.rankBtn];
        btns.forEach(btn => {
            egret.Tween.get(btn).to({ alpha: 0 }, 300);
        });
        await wait(300);
        egret.Tween.removeAllTweens();
        SceneCtrl.instance.change(ModuleTypes.PLAY_SCENE);
    }

    onTap_rankBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.RANK_PANEL);
    }

    get skinKey() { return 'Start' }
}