import { bubbleStandbyGroup, bubbleStandby, bubbleStandbyMask } from "./collisionConfig";
import createBubblePic from "./createBubblePic";
import EgretRender from "../physics/EgretRender";

let timer;
export const startStandbyBubbles = (egretRender:EgretRender) => {
    timer = setInterval(() => {
        const scale = .3;
        const scaleX = .1;
        const p = Math.random() > .5 ? { x: 206, y: 832 } : { x: 551, y: 832 };
        for (let i = 0; i < 10; i++) {
            setTimeout(() => {
                const r = Math.random() * 3 + 6;
                const bubblePic = createBubblePic(r);
                const body = egretRender.circle(p.x, p.y, r, bubblePic, {
                    restitution: 0,
                    force: { x: (Math.random() * .02 - .01) * scaleX, y: -0.02 * scale },
                    collisionFilter: { group: bubbleStandbyGroup, category: bubbleStandby, mask: bubbleStandbyMask }
                });
                setTimeout(() => {
                    egretRender.remove(body)
                }, 800);
            }, i * 50);
        }
        console.log('自动吹');
    }, 2000);
}

export const stopStandbyBubbles = () => {
    clearInterval(timer)
}