import { wall, wallMask, basket, basketMask } from "./collisionConfig";
import StartScene from "./StartScene";

const createBox = (_this: StartScene) => {
    const path1 = Matter.Vertices.fromPath('385 168 640 201 695 528 644 866 392 907 109 868 57 546 118 206 0 206 0 1624 750 1624 750 0', null);
    const body = Matter.Bodies.fromVertices(430, 717, [path1], { isStatic: true, collisionFilter: { group: wall, category: wall, mask: wallMask } }, true);
    Matter.World.add(_this._engine.world, body);

    const path2 = Matter.Vertices.fromPath('118 206 385 168 385 100', null);
    const body2 = Matter.Bodies.fromVertices(425 - 10 - 100 - 10 - 10 + 1, 30 + 100 + 10 + 10 + 6, [path2], { isStatic: true, collisionFilter: { group: wall, category: wall, mask: wallMask } }, true);
    Matter.World.add(_this._engine.world, body2);

    const basketpath = Matter.Vertices.fromPath('290 434 385 502 468 434 466 434 384 488 292 434', null);
    const basketbody = Matter.Bodies.fromVertices(375 + 8 - 2, 400 + 58 + 5 + 4, [basketpath], { isStatic: true, collisionFilter: { group: basket, category: basket, mask: basketMask } }, true);
    Matter.World.add(_this._engine.world, basketbody);
}

export default createBox