import BaseItem from "../../physics/BaseItem";
import MovieClip from "../../physics/movieclip/MovieClip";

const createCoin = (scale) => {
    //气泡纹理种气泡的尺寸默认100（总体还包含气泡周围的阴影效果）
    const texture = RES.getRes('coin_json') as egret.SpriteSheet;
    const animation = createMovieClip(texture, 0.6);
    const baseItem = new BaseItem(animation);
    baseItem.scaleX = baseItem.scaleY = scale;
    return baseItem
}

const createMovieClip = (spritesheet: egret.SpriteSheet, scale = 1) => {
    const list = ['1', '2', '3', '4', '5', '6', '7', '8'];
    const movieclip = new MovieClip({
        spritesheet: spritesheet,
        frameInterval: 6,
        frames: list,
        position: [0, 0],
        scale: scale,
        anchor: [.5, .5]
    });
    return movieclip
}

export default createCoin