import BaseItem from "../../physics/BaseItem";
import MovieClip from "../../physics/movieclip/MovieClip";

const createBoom = (scale) => {
    //气泡纹理种气泡的尺寸默认100（总体还包含气泡周围的阴影效果）
    const boomTexture = RES.getRes('boom_json');
    //炸弹纹理种炸弹的尺寸默认58，不进行缩放
    //气泡和炸弹的比例为100/58
    const animation = createBoomMovieClip(boomTexture);
    const baseItem = new BaseItem(animation, 'boom');
    baseItem.scaleX = baseItem.scaleY = scale;
    return baseItem
}

const createBoomMovieClip = (spritesheet, scale = 1) => {
    const list = ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10'];
    const movieclip = new MovieClip({
        spritesheet: spritesheet,
        frameInterval: 5,
        frames: list,
        position: [0, 0],
        scale: scale,
        anchor: [.5, .5]
    });
    return movieclip
}

export default createBoom