
export default class Loading extends egret.Sprite {
    private static _parent: egret.Sprite;
    private static _instance: Loading;
    static get instace(): Loading {
        return Loading._instance || (Loading._instance = new Loading());
    }

    _bg: egret.Bitmap;
    _progress: egret.Bitmap;
    setSpriteSheet(spritesheet: egret.SpriteSheet) {
        this._bg = new egret.Bitmap(spritesheet.getTexture('bg_png'));
        this._bg.x = 295;
        this._bg.y = 288;
        this._progress = new egret.Bitmap(spritesheet.getTexture('progress_png'));
        this._progress.x = 375;
        this._progress.y = 380;
        this._progress.anchorOffsetX = this._progress.anchorOffsetY = 28;
        this.addChild(this._bg);
        this.addChild(this._progress);
        this.show();
        
    }

    show() {
        Loading._parent.addChild(this);
        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }

    hide() {
        Loading._parent.removeChild(this);
        this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }

    static init(parent: egret.Sprite) {
        Loading._parent = parent;
    }

    onEnterFrame() {
        if (this._progress)
            this._progress.rotation += 5;
    }
}
