import Movable from "../lib/Movable";
import Bullet from "./Bullet";
import { IWeaponHost } from "./IWeaponHost";

export default class Weapon {
  onCreateBullet: Function;
  _timer;
  _count;
  _host: IWeaponHost;
  constructor(host) {
    this._host = host;
    this._timer = setInterval(this.onTimer, 10);
    this.reset();
  }

  reset() {
    this._count = 0;
  }

  onTimer = () => {
    this._count++;
    if (this.canCreateBullet()) {
      this.createBullet();
      this.reset();
    }
  };
  canCreateBullet() {
    return this._count >= this._host.getShootInterval();
  }

  createBullet = () => {
    // console.log('武器在发射子弹')
    const bullet: Bullet = this._host.parent.addChild(new Bullet());
    bullet.host = this._host;
    bullet.velocity = this._host.getShootVelocity();
    bullet.acceleration = this._host.getShootAcceleration();
    const shootPoint = this._host.getShootPoint();
    bullet.position.set(shootPoint.x, shootPoint.y);

    // 添加子弹背景
    const shootBg = this._host.getShootBg();
    shootBg && bullet.addChild(shootBg);

    this._host.movableManager.add(bullet);
  };

  destroy() {
    clearInterval(this._timer);
  }
}
