import DragDropManager from "../dragdrop/DragDropManager";
import MovableManager from "../lib/MovableManager";
import Background from "./Background";
import EnemyFactory from "./EnemyFactory";
import Score from "../tools/Score";
import Pause from "../tools/Pause";
import Boom from "../tools/Boom";
import Hero from "./Hero";
export function addGame(stage: FYGE.Stage) {
  const movableManager = new MovableManager(stage); //创建管理器
  const dragDropManager = new DragDropManager();

  const background = new Background(stage, movableManager);
  const hero = stage.addChild(new Hero(movableManager));
  hero.position.set(300, stage.stageHeight - 200);

  const enemyFactory = new EnemyFactory(stage, movableManager);

  dragDropManager.add(hero);
  this.pause = false;

  // 当前分数
  const score = new Score(stage);
  // 暂停
  const pause = new Pause(stage);
  // 暂停
  const boom = new Boom(stage);

  movableManager.hero = hero;

  function onGamOver() {
    console.log("Score", movableManager.Score);
    alert(`gameOver 您获得的分数为${movableManager.Score}`);
    this.pause = true;
    dragDropManager.remove(hero);
    pause.destroy(stage);
    boom.destroy(stage);
    enemyFactory.destroy();
    movableManager.destroy();
  }
  function boomAll() {
    movableManager.checkAll();
  }

  movableManager.addEventListener("gameover", onGamOver);
  stage.addEventListener("Boom", boomAll);
}
