import DragDropable from "../dragdrop/DragDropable";
import MovableManager from "../lib/MovableManager";
import Vector2 from "../lib/Vector2";
import { IWeaponHost } from "../weapon/IWeaponHost";
import Weapon from "../weapon/Weapon";

export default class Hero extends DragDropable implements IWeaponHost {
  movableManager: MovableManager;

  constructor(movableManager) {
    super();
    this.movableManager = movableManager;
    this.texture = FYGE.Texture.fromUrl(
      "//yun.duiba.com.cn/spark/assets/hero_fly1.f292cb1c04589c6ee395fe29538d5385540755f7.png"
    );

    const weapon = new Weapon(this);

    // const bg = new FYGE.Graphics;
    // bg.beginFill(0xff0000,0.2)
    // bg.drawRect(0,0,99,124)
    // bg.endFill()
    // this.addChild(bg)
  }
  getShootInterval() {
    return 50;
  }
  getShootVelocity() {
    return new Vector2(0, -20);
  }

  getShootPoint() {
    return new FYGE.Point(this.x + this.width / 2, this.y);
  }

  getShootAcceleration() {
    return new Vector2(0, 0);
  }

  getDropPoint(drag: FYGE.MouseEvent) {
    // console.log("stageX", drag.stageX);
    // console.log("stageY", drag.stageY);

    return {};
  }

  getShootBg() {
    return "";
  }

  onDragEnd(drag: DragDropable) {
    // console.log(111, drag);
  }
}
