import MovableManager from "../lib/MovableManager";
import Vector2 from "../lib/Vector2";
import Enemy from "./Enemy";

export default class EnemyFactory {
  private _timer;
  private _stage: FYGE.Stage;
  movableManager: MovableManager;

  constructor(stage: FYGE.Stage, movableManager: MovableManager) {
    this.movableManager = movableManager;
    this._stage = stage;
    this._timer = setInterval(this.onTimer, 1000);
  }

  onTimer = () => {
    const enemy = this._stage.addChildAt(
      new Enemy(this.movableManager),
      this._stage.children.length - 2
    );
    enemy.position.set(Math.random() * 300 + 200, 0);
    enemy.velocity = new Vector2(
      (Math.random() - 0.5) * 2,
      Math.random() * 5 + 2
    );
    // 敌军加速度
    enemy.acceleration = new Vector2(0, 0.05);
  };

  destroy() {
    clearInterval(this._timer);
  }
}
