import Movable from "../lib/Movable";
import MovableManager from "../lib/MovableManager";
import Vector2 from "../lib/Vector2";
import { IWeaponHost } from "../weapon/IWeaponHost";
import Weapon from "../weapon/Weapon";

export default class Enemy extends Movable implements IWeaponHost {
  movableManager: MovableManager;
  constructor(movableManager: MovableManager) {
    super();
    this.movableManager = movableManager;

    movableManager.add(this);

    this.texture = FYGE.Texture.fromUrl(
      "//yun.duiba.com.cn/aurora/assets/26e1539bb9c5961c693f05186b086c8e04f2f6a2.png"
    );

    const weapon = new Weapon(this);

    const bg = new FYGE.Graphics();
    bg.beginFill(0x00ff00, 0.2);
    bg.drawRect(0, 0, 69, 88);
    bg.endFill();
    this.addChild(bg);

    this.addEventListener(FYGE.Event.REMOVED_FROM_STAGE, () => {
      // console.log('敌人消失了')
      weapon.destroy();
    });
  }

  getShootInterval() {
    return 50;
  }

  getShootVelocity() {
    return new Vector2(0, 10);
  }

  getShootAcceleration() {
    return new Vector2(0, 0);
  }

  // 子弹背景
  getShootBg() {
    const bg = new FYGE.Graphics();
    bg.beginFill(0x00ff00, .3);
    bg.drawRect(0, 0, 18, 42);
    bg.endFill();

    return bg;
  }

  getShootPoint() {
    return new FYGE.Point(this.x + this.width / 2, this.y + this.height);
  }
}
