import Movable from "../lib/Movable";
import MovableManager from "../lib/MovableManager";
import Vector2 from "../lib/Vector2";
class BackgroundItem extends Movable {
  constructor() {
    super();
    this.texture = FYGE.Texture.fromUrl(
      "//yun.duiba.com.cn/aurora/assets/bd7b3b10169265123e52d02acf8739db5ff59b3d.png"
    );
    this.velocity = new Vector2(0, 5);
  }
  getCanRemove() {
    return false;
  }
}
const height = 1624;
export default class Background {
  constructor(stage: FYGE.Stage, movableManager: MovableManager) {
    var bg = new BackgroundItem();
    var bg2 = new BackgroundItem();

    movableManager.add(bg);
    movableManager.add(bg2);

    stage.addChild(bg);
    stage.addChild(bg2);

    bg.x = 0;
    bg2.y = height;

    stage.addEventListener(FYGE.Event.ENTER_FRAME, () => {
      // console.log("bg.y", bg.y);
      // console.log("bg2.y", bg2.y);
      if (bg.y > height) {
        bg.y = bg2.y - height;
      }
      if (bg2.y > height) {
        bg2.y = bg.y - height;
      }
    });
  }
}
