import Enemy from "../planewar/Enemy";
import Hero from "../planewar/Hero";
import Bullet from "../weapon/Bullet";
import Movable from "./Movable";
import ScoreClass from "../tools/Score";

let scoreClass;
export default class MovableManager extends FYGE.EventDispatcher {
  private _stage: FYGE.Stage;
  public Score: 0;
  private _movableList: Movable[] = [];
  hero: Hero;

  constructor(stage: FYGE.Stage) {
    super();
    this._stage = stage;
    this.Score = 0;
    scoreClass = new ScoreClass(stage);

    this._stage.addEventListener(FYGE.Event.ENTER_FRAME, this.onEnterFrame);

    this._stage.addEventListener(
      FYGE.MouseEvent.MOUSE_DOWN,
      this.touchStage,
      this
    );
    this._stage.addEventListener(
      FYGE.MouseEvent.MOUSE_MOVE,
      this.touchStage,
      this
    );
    this._stage.addEventListener(
      FYGE.MouseEvent.MOUSE_UP,
      this.touchStage,
      this
    );
  }

  onEnterFrame = () => {
    this.step();
    this.checkRemove();
    this.checkHitEnemy();
    this.checkHitByBullet();
    this.checkHitByEnemy();

    // console.log('移动对象的数量:', this._movableList.length)
  };

  checkHitByEnemy() {
    const enemyList = this._movableList.filter((i) => i instanceof Enemy);
    for (let i = 0; i < enemyList.length; i++) {
      const oneEnemy = enemyList[i];

      if (this.checkHit(oneEnemy, this.hero)) {
        console.log("被敌机碰撞了，游戏结束了");
        // this.Score = 0;
        this.gameOver();
        return;
      }
    }
  }

  private gameOver() {
    this._stage.removeEventListener(FYGE.Event.ENTER_FRAME, this.onEnterFrame);
    this.dispatchEvent("gameover");
  }

  private addScore() {
    this.Score += 10;
    // console.log("this.Score", this.Score);
    scoreClass.change(this.Score);
  }

  /**
   * 判断是否超出边界
   */
  judgeEdge() {
    const { width, height, x, y } = this.hero;
    // console.log("this.hero", this.hero);
    const dx = width,
      dy = height;
    const { stageWidth: wW, stageHeight: wH } = this._stage;
    // console.log("wW", wW);
    // console.log("wH", wH);

    // console.log("dx", dx);
    // console.log("dy", dy);

    // console.log("x", x);
    // console.log("y", y);
    if (x < 0) {
      // console.log("x < 0");

      this.hero.x = 0;
    } else if (x > wW - dx) {
      // console.log("x > wW");
      this.hero.x = wW - dx;
    }

    if (y < dy) {
      this.hero.y = 0;
    } else if (y > wH - dy) {
      this.hero.y = wH - dy;
    }
  }

  /**
   * 鼠标点到的差值
   * @type {{x: number, y: number}}
   */
  mouseDP = { x: 0, y: 0 };

  /**
   * 在stage上触摸
   * @param {MouseEvent} e
   */
  touchStage(e) {
    switch (e.type) {
      case FYGE.MouseEvent.MOUSE_DOWN:
        this.mouseDP.x = e.localX - this.hero.x;
        this.mouseDP.y = e.localY - this.hero.y;
        // console.log("MOUSE_DOWN");
        // console.log("mouseDP", this.mouseDP);
        break;

      case FYGE.MouseEvent.MOUSE_UP:
        // console.log("MOUSE_UP");

      case FYGE.MouseEvent.MOUSE_MOVE:
        // console.log("MOUSE_MOVE");

        const px = e.localX - this.mouseDP.x;
        const py = e.localY - this.mouseDP.y;
        // console.log("px", px);
        // console.log("py", py);
        this.judgeEdge();
        break;
    }
  }

  destroy() {
    this._stage.removeEventListener(
      FYGE.MouseEvent.MOUSE_DOWN,
      this.touchStage,
      this
    );
    this._stage.removeEventListener(
      FYGE.MouseEvent.MOUSE_MOVE,
      this.touchStage,
      this
    );
    this._stage.removeEventListener(
      FYGE.MouseEvent.MOUSE_UP,
      this.touchStage,
      this
    );
  }

  checkHitByBullet() {
    const enemyBulletList = this._movableList.filter(
      (i) => i instanceof Bullet && i.host instanceof Enemy
    );
    for (let j = 0; j < enemyBulletList.length; j++) {
      const bullet = enemyBulletList[j];
      if (this.checkHit(this.hero, bullet)) {
        console.log("被子弹碰撞了，游戏结束了");
        // this.Score = 0;
        this.gameOver();
        return;
      }
    }
  }

  checkAll() {
    const enemyAllList = this._movableList.filter((i) => i instanceof Enemy);
    enemyAllList.forEach((enemy) => {
      this.remove(enemy);
      console.log("全屏爆炸");
    });
  }

  private checkHitEnemy() {
    const heroBulletList = this._movableList.filter(
      (i) => i instanceof Bullet && i.host instanceof Hero
    );
    const enemyList = this._movableList.filter((i) => i instanceof Enemy);
    for (let i = 0; i < enemyList.length; i++) {
      const oneEnemy = enemyList[i];
      for (let j = 0; j < heroBulletList.length; j++) {
        const onHeroBullet = heroBulletList[j];
        if (this.checkHit(oneEnemy, onHeroBullet)) {
          this.addScore();

          this.remove(oneEnemy);
          this.remove(onHeroBullet);
          return;
        }
      }
    }
  }

  private checkHit(A: FYGE.DisplayObject, B: FYGE.DisplayObject) {
    const pointA = [A.x + A.width / 2, A.y + A.height / 2];
    const pointB = [B.x + B.width / 2, B.y + B.height / 2];
    const x0 = Math.abs(pointA[0] - pointB[0]);
    const y0 = Math.abs(pointA[1] - pointB[1]);
    const x1 = A.width / 2 + B.width / 2;
    const y1 = A.height / 2 + B.height / 2;
    return x0 < x1 && y0 < y1;
  }

  private calcCanRemove(item: Movable) {
    if (!item.getCanRemove()) return;
    if (item.y > 1624) return true;
    if (item.y < -item.height) return true;
    if (item.x > 750) return true;
    if (item.x < -item.width) return true;
    return false;
  }

  private checkRemove() {
    for (let index = 0; index < this._movableList.length; index++) {
      const item = this._movableList[index];
      if (this.calcCanRemove(item)) {
        this._movableList.splice(index, 1);
        item.parent && item.parent.removeChild(item);
        return;
      }
    }
  }

  private step() {
    this._movableList.forEach((item) => item.step());
  }

  add(item: Movable) {
    this._movableList.push(item);
  }

  remove(item: Movable) {
    const index = this._movableList.indexOf(item);
    this._movableList.splice(index, 1);
    item.parent && item.parent.removeChild(item);
  }
}
