import Vector2 from "./Vector2";

export default class Movable extends FYGE.Sprite {
  getCanRemove() {
    return true;
  }
  private _velocity: Vector2;
  set velocity(val: Vector2) {
    this._velocity = val;
  }
  get velocity() {
    return this._velocity;
  }
  private _acceleration: Vector2;
  set acceleration(val: Vector2) {
    this._acceleration = val;
  }

  step() {
    this._acceleration = this._acceleration || new Vector2(0, 0);
    this._velocity.x += this._acceleration.x;
    this._velocity.y += this._acceleration.y;
    this.y += this._velocity.y;
    this.x += this._velocity.x;
  }
}
