package cn.com.duiba.mysql.generator.gencode;

import cn.com.duiba.mysql.generator.entity.GeneratorConfig;
import cn.com.duiba.mysql.generator.entity.TableEntity;
import cn.com.duiba.mysql.generator.service.DuibaFreemarkerService;
import cn.com.duiba.mysql.generator.utils.PathUtils;

/**
 * @author sunchangji
 */
public class JavaEntityGenerator extends AbstractGenerator{


    public JavaEntityGenerator(DuibaFreemarkerService freemarkerService, TableEntity tableEntity, GeneratorConfig config){
        super(freemarkerService,tableEntity, config);
    }

    @Override
    public String getFTL() {
        return "java_entity";
    }

    @Override
    public String genFileName() {
        return tableEntity.getClassName() + "Entity.java";
    }

    @Override
    protected String genFilePath() {
        return PathUtils.getPathByPackage(config.getEntityPackage(), config);
    }
}
