package cn.com.duiba.mysql.generator.gencode;

import cn.com.duiba.mysql.generator.entity.GeneratorConfig;
import cn.com.duiba.mysql.generator.entity.TableEntity;
import cn.com.duiba.mysql.generator.service.DuibaFreemarkerService;
import cn.com.duiba.mysql.generator.utils.PathUtils;

/**
 * Created by sunchangji on 2019/3/29.
 */
public class JavaDaoImplGenerator extends AbstractGenerator{

	public JavaDaoImplGenerator(DuibaFreemarkerService freemarkerService, TableEntity tableEntity, GeneratorConfig config) {
		super(freemarkerService, tableEntity, config);
	}

	@Override
	protected String getFTL() {
		return "java_dao_impl";
	}

	@Override
	public String genFileName() {
		return tableEntity.getClassName() + "DaoImpl.java";
	}

	@Override
	protected String genFilePath() {
		return PathUtils.getPathByPackage(config.getDaoPackage()+".impl", config);
	}
}
