package cn.com.duiba.mysql.generator;

import cn.com.duiba.mysql.generator.entity.GeneratorConfig;
import cn.com.duiba.mysql.generator.entity.TableEntity;
import cn.com.duiba.mysql.generator.exceptions.DuibaGeneratorException;
import cn.com.duiba.mysql.generator.gencode.JavaDaoGenerator;
import cn.com.duiba.mysql.generator.gencode.JavaDaoImplGenerator;
import cn.com.duiba.mysql.generator.gencode.JavaEntityGenerator;
import cn.com.duiba.mysql.generator.gencode.SQLXmlGenerator;
import cn.com.duiba.mysql.generator.service.DuibaFreemarkerService;
import cn.com.duiba.mysql.generator.utils.DBUtils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

/**
 * 代码生成器
 * @author sunchangji
 */
public class MybatisGenerator {

    /**
     * 代码生成器主类
     *
     * @return
     */
    public static void genCode(GeneratorConfig config) {
        check(config);

        DuibaFreemarkerService freemarkerService = new DuibaFreemarkerService();
        TableEntity tableEntity = null;
        try {
            tableEntity = DBUtils.getTableInfo(config);
        } catch (SQLException e) {
            throw new DuibaGeneratorException(e);
        }
        //生成entity文件
        JavaEntityGenerator doGenerator = new JavaEntityGenerator(freemarkerService, tableEntity, config);
        doGenerator.gen();
        //生成dao文件
        JavaDaoGenerator daoGenerator = new JavaDaoGenerator(freemarkerService, tableEntity, config);
        daoGenerator.gen();
        //生成daoImpl文件
        JavaDaoImplGenerator daoImplGenerator = new JavaDaoImplGenerator(freemarkerService, tableEntity, config);
        daoImplGenerator.gen();
        //生成xml文件
        SQLXmlGenerator sqlXmlGenerator = new SQLXmlGenerator(freemarkerService, tableEntity, config);
        sqlXmlGenerator.gen();
    }

    private static void check(GeneratorConfig config) {
        if (config == null){
            throw new DuibaGeneratorException("生成代码前请设置");
        }

        config.check();
    }

    public static Connection getConnection(String url, String user, String pwd){
        Connection connection = null;
        try {
            Class.forName("com.mysql.jdbc.Driver");
            connection = DriverManager.getConnection(url, user,pwd);
        } catch (ClassNotFoundException | SQLException e) {
            throw new DuibaGeneratorException(e);
        }
        return connection;
    }
}
