package cn.com.duiba.mysql.generator.gencode;

import cn.com.duiba.mysql.generator.entity.GeneratorConfig;
import cn.com.duiba.mysql.generator.entity.TableEntity;
import cn.com.duiba.mysql.generator.exceptions.DuibaGeneratorException;
import cn.com.duiba.mysql.generator.service.DuibaFreemarkerService;
import org.apache.commons.io.IOUtils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * @author sunchangji
 */
public abstract class AbstractGenerator {

	private DuibaFreemarkerService freemarkerService;

	protected TableEntity tableEntity;

	protected GeneratorConfig config;

	private Map<String, Object> params = new HashMap<>();

	public AbstractGenerator(DuibaFreemarkerService freemarkerService, TableEntity tableEntity, GeneratorConfig config) {
		this.freemarkerService = freemarkerService;
		this.tableEntity = tableEntity;
		this.config = config;

		params.put("table", tableEntity);
		params.put("pk", tableEntity.getPk());
		params.put("pathName", tableEntity.getClassname().toLowerCase());
		params.put("columns", tableEntity.getColumns());
		params.put("entityPackage", config.getEntityPackage());
		params.put("daoPackage", config.getDaoPackage());
		params.put("uks", tableEntity.getUniqueKeyMap());

		params.put("pre", "#{");
		params.put("end", "}");
	}

	public final void gen() {
		//利用Freemarker生成代码字符串
		String genStr = freemarkerService.merge(getFTL(), params);
		//生成文件名
		String fileName = genFileName();
		String filePath = genFilePath();
		//写文件
		this.writeFile(genStr, filePath, fileName);
	}

	/**
	 * 文件不存在的情况下生成文件
	 *
	 * @param content
	 * @param dirPath  文件目录
	 * @param fileName 文件名称
	 */
	private void writeFile(String content, String dirPath, String fileName) {
		File fp = new File(dirPath);
		if (!fp.exists()) {
			boolean dirs = fp.mkdirs();
			if (!dirs) {
				throw new DuibaGeneratorException(dirPath + " 文件目录创建失败");
			}
		}
		String file = dirPath + File.separator + fileName;
		File ff = new File(file);
		if (!ff.exists()) {
			try {
				boolean success = ff.createNewFile();
				if (!success) {
					throw new DuibaGeneratorException(file + "创建失败");
				}
				FileOutputStream fos = new FileOutputStream(file);
				IOUtils.write(content, fos);
				fos.close();
			} catch (IOException e) {
				throw new DuibaGeneratorException(file + " error " + e);
			}
		}
	}

	protected abstract String getFTL();

	protected abstract String genFileName();

	protected abstract String genFilePath();
}
