package cn.com.duiba.jdactivity.developer.jd.constant;

import java.util.Objects;

public enum JdShopEnum {
    TEST_01("开放运营部测试店铺一号", 10276497L, 10139787L),
    BOSIDENG("波司登官方旗舰店", 48034L, 44892L);

    private final String shopName;

    /**
     * 商家Id
     */
    private final Long venderId;

    /**
     * 店铺Id
     */
    private final Long shopId;

    JdShopEnum(String shopName, Long venderId, Long shopId) {
        this.shopName = shopName;
        this.shopId = shopId;
        this.venderId = venderId;
    }

    public String getShopName() {
        return shopName;
    }

    public Long getShopId() {
        return shopId;
    }

    public Long getVenderId() {
        return venderId;
    }

    public static JdShopEnum getJdShop(Long venderId, Long shopId) {
        if (venderId == null || shopId == null || venderId == 0L || shopId == 0L) {
            return null;
        }
        for (JdShopEnum value : values()) {
            if (Objects.equals(value.getVenderId(), venderId) && Objects.equals(value.getShopId(), shopId)) {
                return value;
            }
        }
        return null;
    }
}
