package cn.com.duiba.jdactivity.controller;

import cn.com.duiba.jdactivity.common.utils.HttpClientUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Optional;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/5/18 12:51
 */
@Controller
@RequestMapping("/jd")
public class HtmlController {
    public static final Logger LOGGER = LoggerFactory.getLogger(HtmlController.class);

    @Resource
    private HttpClientUtil httpClientUtil;

    @Value("${serverless.request.html.url}")
    private String serverlessDomain;

    @RequestMapping(value = "/{projectId}/index.html")
    @ResponseBody
    public String index(@PathVariable String projectId, HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            String html = httpClientUtil.sendGet(serverlessDomain+"/tbjd/"+ projectId +"/c/test/index.html");
            return html;
        } catch (Exception e) {
            e.printStackTrace();
            LOGGER.info("获取index页报错,result={}", e);
        }
        return "";
    }
}
