package cn.com.duiba.jdactivity.developer.jd.utils;

import cn.com.duiba.jdactivity.common.utils.RequestTool;
import cn.com.duiba.jdactivity.developer.jd.constant.JdAppEnum;
import cn.com.duiba.jdactivity.developer.jd.constant.JdServerUrlEnum;
import com.alibaba.fastjson.JSON;
import com.jd.open.api.sdk.DefaultJdClient;
import com.jd.open.api.sdk.JdClient;
import com.jd.open.api.sdk.request.platform.IsvUploadDBOperationLogRequest;
import com.jd.open.api.sdk.request.platform.IsvUploadLoginLogRequest;
import com.jd.open.api.sdk.response.platform.IsvUploadDBOperationLogResponse;
import com.jd.open.api.sdk.response.platform.IsvUploadLoginLogResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

/**
 * https://jos.jd.com/commondoc?listId=104
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/5/18 14:31
 */
@Component
public class LogUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger(LogUtil.class);


    private static String getDeviceId() {
        return RequestTool.getHttpServletRequest().getHeader("device_id");
    }

    public void logLogin(JdAppEnum jdAppEnum, boolean loginSuccess, String jdId, String userId) {
        try {
            JdClient client = getClient(jdAppEnum);
            IsvUploadLoginLogRequest request = new IsvUploadLoginLogRequest();
            request.setResult(loginSuccess ? 0 : 1);
            request.setUserIp(getClientIp());
            request.setAppName(jdAppEnum.getAppName());
            request.setJosAppKey(jdAppEnum.getAppKey());
            request.setJdId(jdId);
            request.setDeviceId(getDeviceId());
            request.setUserId(userId);
            request.setMessage(loginSuccess ? "登录成功" : "登陆失败");
            request.setTimeStamp(System.currentTimeMillis());
            IsvUploadLoginLogResponse response = client.execute(request);
            Integer c = response.getC();

            boolean success = Objects.equals(0, c);
            LOGGER.info("logLogin,result={}", success);
            if (!success) {
                LOGGER.info("logLogin,request={},response={}", JSON.toJSONString(request), JSON.toJSONString(response));
            }
        } catch (Exception e) {
            LOGGER.info("logLogin,exception", e);
        }
    }

    public void logDBOperation(JdAppEnum jdAppEnum, String jdId, String db, String sql) {
        try {
            JdClient client = getClient(jdAppEnum);
            IsvUploadDBOperationLogRequest request = new IsvUploadDBOperationLogRequest();
            request.setUserIp(getClientIp());
            request.setAppName(jdAppEnum.getAppName());
            request.setJosAppKey(jdAppEnum.getAppKey());
            request.setDeviceId(getDeviceId());
            request.setUserId(jdId);
            request.setUrl(RequestTool.getRequestUrl(RequestTool.getHttpServletRequest()));
            if (StringUtils.isBlank(db)) {
                db = "custom";
            }
            request.setDb(db);
            request.setSql(sql);
            request.setTimeStamp(System.currentTimeMillis());
            IsvUploadDBOperationLogResponse response = client.execute(request);
            Integer c = response.getC();
            boolean success = Objects.equals(0, c);
            LOGGER.info("logDBOperation,result={}", success);
            if (!success) {
                LOGGER.info("logDBOperation,request={},response={}", JSON.toJSONString(request), JSON.toJSONString(response));
            }
        } catch (Exception e) {
            LOGGER.info("logDBOperation,exception", e);
        }


    }


    /**
     * 访问请求的客户端外网 IP。
     * 如果使用了 SLB，客户端 IP 添加在 HTTP 访问请求的 X-Forwarded-For 属性的末尾。
     */
    public String getClientIp() {
        HttpServletRequest request = RequestTool.getHttpServletRequest();
        String ip = request.getHeader("x-forwarded-for");
        if (StringUtils.isNotBlank(ip)) {
            String[] ips = ip.trim().split(",");
            int i = Math.max(0, ips.length - 1);
            ip = ips[i].trim();
        }
        if (StringUtils.isNotBlank(ip)) {
            return ip;
        }

        return RequestTool.getIpAddr(request);
    }

    private DefaultJdClient getClient(JdAppEnum jdAppEnum) {
        return new DefaultJdClient(JdServerUrlEnum.LOG_URL.getUrl(), "", jdAppEnum.getAppKey(), jdAppEnum.getAppSecret());
    }
}
