package cn.com.duiba.jdactivity.controller;

import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.jdactivity.common.utils.AESCS7Util;
import cn.com.duiba.jdactivity.common.utils.UrlUtils;
import cn.com.duiba.jdactivity.common.vo.Result;
import cn.com.duiba.jdactivity.common.vo.ResultBuilder;
import cn.com.duiba.jdactivity.developer.jd.constant.JdAppEnum;
import cn.com.duiba.jdactivity.developer.jd.constant.JdTokenSourceEnum;
import cn.com.duiba.jdactivity.developer.jd.utils.AccessTokenUtils;
import cn.com.duiba.jdactivity.developer.jd.utils.JdApiUtil;
import cn.com.duiba.jdactivity.dto.AutologinParam;
import cn.com.duiba.jdactivity.dto.TbShopAccessTokenDto;
import cn.com.duiba.jdactivity.exception.BizException;
import com.alibaba.fastjson.JSON;
import com.jd.open.api.sdk.domain.user.UserRelatedRpcService.response.getUserInfoByOpenId.OAuthUserInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * 开放给兰蔻接口
 *
 * @author cxw
 * @date 2022/7/15 13:26
 */
@RestController
@RequestMapping("/open2Lankou")
public class Open2LankouController {
    public static final Logger LOGGER = LoggerFactory.getLogger(Open2LankouController.class);
    public static final String ENCRYPT_KEY = "JuGi3FCECD1dA2BPL1lCWC==";
    public static final String APP_KEY = "lankou";
    public static final String APP_SECRET = "1ff078fc0c742773";
    @Resource
    private JdApiUtil jdApiUtil;
    @Resource
    private AccessTokenUtils accessTokenUtils;

    /**
     * todo 根据环境获取不同的兰蔻地址
     */
    private static String getAutologinHome(String env) {
        if (StringUtils.isBlank(env)) {
            env = "";
        }
        env = env.toLowerCase();
        String path = "/activity/common/api/autoLogin.login/";
        String host;
        switch (env) {
            case "dev":
                host = "http://localhost:8181";
                break;
            case "test":
                host = "http://activity.m.duibatest.com.cn";
                break;
            case "pre":
                host = "http://activity.m.duibapre.com.cn";
                break;
            default:
                // 默认为线上
                host = "http://activity.m.duiba.com.cn";
                break;
        }
        return host + path;
    }

    /**
     * 微信、京东端 用户登陆后跳转到兰蔻
     *
     * @return
     */
    @PostMapping("/autologin")
    public Result<String> autologin(@RequestBody AutologinParam autologinParam) {
        try {
            LOGGER.info("autologin,autologinParam={}", JSON.toJSONString(autologinParam));
            String token = autologinParam.getToken();
            String source = Optional.ofNullable(autologinParam.getSource()).orElse(JdTokenSourceEnum.JD.getSource());
            LOGGER.info("source,source={}", source);
            String redirectUrl = autologinParam.getRedirectUrl();
            String env = autologinParam.getEnv();
            Long venderId = autologinParam.getVenderId();
            Long shopId = autologinParam.getShopId();

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(venderId, shopId);
            LOGGER.info("获取accessToken,结果={}", JSON.toJSONString(accessToken));

            JdAppEnum appByAppKey = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            Result<String> pinByToken = jdApiUtil.getPinByToken(appByAppKey, accessToken.getAccessToken(), source, token);
            LOGGER.info("获取pin,结果={}", JSON.toJSONString(pinByToken));

            Result<String> openIdByToken = jdApiUtil.getOpenIdByToken(appByAppKey, source, token);
            LOGGER.info("获取openId,结果={}", JSON.toJSONString(openIdByToken));

            Result<OAuthUserInfo> userInfoByOpenId = jdApiUtil.getUserInfoByOpenId(appByAppKey, accessToken.getAccessToken(), openIdByToken.getData());
            LOGGER.info("获取userInfo,结果={}", JSON.toJSONString(userInfoByOpenId));
            String uid = convert2Uid(appByAppKey, accessToken.getAccessToken(), pinByToken.getData());
            LOGGER.info("加密pin,pin={},uid={}", pinByToken.getData(), uid);
            String nickName = userInfoByOpenId.getData().getNickName();
            String avatar = userInfoByOpenId.getData().getImageUrl();
            String credits = null;
            if (StringUtils.equals(autologinParam.getNeedCredits(), "1")) {
                Result<Long> customerPoints = jdApiUtil.getCustomerPoints(appByAppKey, pinByToken.getData(), accessToken.getAccessToken());
                credits = String.valueOf(customerPoints.getData());
            }
            // 查询是否关注店铺
            Result<Boolean> follow = jdApiUtil.isFollowByPinAndVid(appByAppKey, pinByToken.getData(), shopId);
            String autoLogin = autologin(uid, nickName, avatar, redirectUrl, env, credits, follow != null ? follow.getData() : false);
            LOGGER.info("autoLogin={}", autoLogin);
            return ResultBuilder.success(autoLogin);
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("跳转异常", e);
            return ResultBuilder.fail("跳转异常");
        }
    }

    /**
     * 生成免登url
     */
    private String autologin(String uid, String nickName, String avatar, String redirectUrl, String env, String credits, boolean isFollow) throws UnsupportedEncodingException {

        if (env != null && env.equals("taobao")) {
            LOGGER.info("taobaourl,avatar={},nickname={},uid={},url={}", avatar, nickName, uid, redirectUrl + "&avatar=" + avatar + "&nickname=" + nickName + "&uid=" + uid);
            LOGGER.info("redirectUrl={}", redirectUrl);
            return redirectUrl + "&avatar=" + avatar + "&nickname=" + nickName + "&uid=" + uid;
        }
        if (env != null && env.equals("taobaoshare")) {
            LOGGER.info("taobaourl,avatar={},nickname={},uid={},url={}", avatar, nickName, uid, redirectUrl + "&avatar=" + avatar + "&nickname=" + nickName + "&uid=" + uid);
            LOGGER.info("redirectUrl={}", redirectUrl);
            return URLDecoder.decode(redirectUrl, "UTF-8") + "&avatar=" + avatar + "&nickname=" + nickName + "&uid=" + uid;
        }

        if (StringUtils.equalsIgnoreCase("null", redirectUrl)) {
            redirectUrl = "";
        }
        //免登参数
        Map<String, String> params = new HashMap<>();
        if (StringUtils.isNotBlank(redirectUrl)) {
            redirectUrl = UrlUtils.urlDecode(redirectUrl);
            params.put("redirect", redirectUrl);
        }
        params.put("uid", uid);
        params.put("nickname", nickName);
        params.put("avatar", avatar);
        params.put("followShop", isFollow ? "1" : "0");
        if (StringUtils.isNotBlank(credits)) {
            params.put("credits", credits);
        }

        //增加签名参数
        params.put("appKey", APP_KEY);
        params.put("appSecret", APP_SECRET);
        if (params.get("timestamp") == null) {
            params.put("timestamp", System.currentTimeMillis() + "");
        }
        //计算签名值
        String sign = SignTool.sign(params);
        params.put("sign", sign);
        params.remove("appSecret");
        //json字符串参数
        String paramsJsonStr = JSON.toJSONString(params);
        String autoUrl = getAutologinHome(env);
        return autoUrl + "?data=" + URLEncoder.encode(paramsJsonStr, "UTF-8");
    }

    public static String convert2Uid(JdAppEnum appByAppKey, String accessToken, String pin) throws BizException {
        try {
            String uid = AESCS7Util.AESEncrypt(pin, ENCRYPT_KEY);
            LOGGER.info("pin加密,pin={},uid={}", pin, uid);
            return uid;
        } catch (Exception e) {
            LOGGER.error("pin加密失败,uid={}", pin, e);
            throw new BizException("pin加密失败");
        }
    }

}
