package cn.com.duiba.jdactivity.common.utils;

import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.util.Base64Utils;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.security.InvalidKeyException;
import java.security.Security;

/**
 * 密文编码：Base64；明文编码：UTF-8；
 * 填充方式：AES/ECB/PKCS7Padding
 * 类库：使用bcprov-jdk15on类库实现AES加解密
 * <p>
 * Created by 歪大哥😁 on 2019-09-12.
 */
public class AESCS7Util {


    static final String ENCODING = "UTF-8";
    static final String AES_PADDING = "AES/ECB/PKCS7Padding";

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastleProvider());
        } else {
            Security.removeProvider(BouncyCastleProvider.PROVIDER_NAME);
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    // 解密
    public static String AES256Decrypt(String data, String key) throws Exception {
        try {
            SecretKey k = new SecretKeySpec(key.getBytes(ENCODING), "AES");
            Cipher cipher = Cipher.getInstance(AES_PADDING, "BC");
            cipher.init(Cipher.DECRYPT_MODE, k);
            byte[] result = cipher.doFinal(Base64Utils.decode(data.getBytes(ENCODING)));
            return new String(result, ENCODING);
        } catch (InvalidKeyException ie) {
            throw new Exception(ie.getMessage() + ". 请下载无政策限制版本的jre，并将local_policy.jar、US_export_policy.jar文件覆盖到jre/lib/security下");
        } catch (Exception e) {
            throw e;
        }
    }

    // 加密
    public static String AESEncrypt(String data, String key) throws Exception {
        try {
            SecretKey k = new SecretKeySpec(key.getBytes(ENCODING), "AES");
            Cipher cipher = Cipher.getInstance(AES_PADDING, "BC");
            cipher.init(Cipher.ENCRYPT_MODE, k);
            return new String(Base64Utils.encode(cipher.doFinal(data.getBytes(ENCODING))), ENCODING);
        } catch (InvalidKeyException ie) {
            throw new Exception(ie.getMessage() + ". 请下载无政策限制版本的jre，并将local_policy.jar、US_export_policy.jar文件覆盖到jre/lib/security下");
        }
    }

    public static void main(String[] args) throws Exception {
        /*
           aesKey:         JuGi3FCECD1dA2BPL1lCWC==
                    加密模式：ECB
                    测试字符串：加密前："test"，加密后:"JP+BniurQVyE0e4vcIvnYw=="
           加密字段：uid
        */
        String key = "JuGi3FCECD1dA2BPL1lCWC==";
        String test = AESEncrypt("jd_6bdf29cf7cf49", key);
        System.out.println(test);
        System.out.println(AES256Decrypt(test, key));
    }
}

