package cn.com.duiba.jdactivity.common.utils.user;

import cn.com.duiba.jdactivity.common.utils.AESCS7Util;
import cn.com.duiba.jdactivity.common.utils.RequestLocal;
import cn.com.duiba.jdactivity.common.utils.RequestTool;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/5/17 18:54
 */
public class UserUtils {


    private static final String USER_COOKIE = "COMMERCIAL_CONSUMER_WDATA3_COOKIE";
    private static final String ENCRYPT_KEY = "oldConsumerEncryptKey";

    /**
     * 登录时间在24小时内为有效
     */
    private static boolean isValidTime(long loginTime) {
        long now = System.currentTimeMillis();
        return loginTime > now - 86400000 && loginTime < now + 300000;
    }

    /**
     * 注入cookies
     */
    public static void injectConsumerInfoIntoCookie(ShopUserCookieDto shopUserCookieDto) {
        RequestLocal.setUser(shopUserCookieDto);

        HttpServletRequest request = RequestTool.getHttpServletRequest();
        HttpServletResponse response = RequestTool.getHttpServletResponse();
        String userJson = JSONObject.toJSONString(shopUserCookieDto);

        String userCookieVal = null;
        try {
            userCookieVal = AESCS7Util.AESEncrypt(userJson, ENCRYPT_KEY);
        } catch (Exception e) {
            e.printStackTrace();
        }

        String reqDomain = getRequestDomain(request);
        if (reqDomain != null) {
            Cookie reqUserCookie = new Cookie(USER_COOKIE, userCookieVal);
            //防止被js获得
            reqUserCookie.setHttpOnly(true);
            reqUserCookie.setDomain(reqDomain);
            reqUserCookie.setPath("/");

            response.addCookie(reqUserCookie);
        }
    }

    public static ShopUserCookieDto getUserCookieDto(HttpServletRequest request) {
        String cookie = RequestTool.getCookie(request, USER_COOKIE);
        if (cookie == null || cookie.isEmpty()) {
            return null;
        }
        String userJson = null;//如果ts是伪造的，则解密时可能会抛出异常，需要处理
        try {
            userJson = AESCS7Util.AES256Decrypt(cookie, ENCRYPT_KEY);
        } catch (Exception e) {
            e.printStackTrace();
        }
        ShopUserCookieDto c = JSONObject.parseObject(userJson, ShopUserCookieDto.class);
        if (!isValidTime(c.getLoginTime())) {
            return null;
        }
        return c;
    }

    /**
     * 获取本次请求的域名,如果和配置的域名不一致才会返回当前请求的域名,否则返回null
     *
     * @param request 请求对象
     * @return
     */
    public static String getRequestDomain(HttpServletRequest request) {
        String domainName = request.getServerName();
        if (domainName == null || "".equals(domainName)) {
            return null;
        }
        return domainName;
    }
}
