package cn.com.duiba.jdactivity.developer.jd.utils;

import cn.com.duiba.jdactivity.BaseTest;
import cn.com.duiba.jdactivity.developer.jd.constant.JdAppEnum;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/5/18 16:12
 */
class EncryptUtilTest extends BaseTest {
    @Resource
    private EncryptUtil encryptUtil;

    @Test
    void test() {
        String plaintext = "yi皮仔";
        testEncryptString(plaintext, "dfef1ede28aa455999ddefe2944980cfzguy");
        // for (int i = 0; i < 10000; i++) {
        //     testEncryptString(plaintext + i);
        // }
    }

    private void testEncryptString(String plaintext, String accessToken) {
        long l = System.currentTimeMillis();
        String encryptString = encryptUtil.encryptString(JdAppEnum.DUIBA, accessToken, plaintext);
        System.out.println("加密耗时" + (System.currentTimeMillis() - l));
        System.out.println(encryptString);
        l = System.currentTimeMillis();
        String decryptString = encryptUtil.decryptString(JdAppEnum.DUIBA, accessToken, encryptString);
        System.out.println("解密耗时" + (System.currentTimeMillis() - l));
        boolean equals = Objects.equals(plaintext, decryptString);
        Assertions.assertTrue(equals);
    }


}