package cn.com.duiba.jdactivity.interceptor;

import cn.com.duiba.jdactivity.common.utils.RequestLocal;
import cn.com.duiba.jdactivity.common.utils.user.ShopUserCookieDto;
import cn.com.duiba.jdactivity.common.utils.user.UserUtils;
import cn.com.duiba.jdactivity.common.vo.ResultBuilder;
import com.alibaba.fastjson.JSONObject;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/5/17 18:41
 */
// @Component
public class LoginInterceptor implements HandlerInterceptor {

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        RequestLocal.removeUser();

        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod) handler;
            UnloginAccess unloginAccess = handlerMethod.getMethod().getAnnotation(UnloginAccess.class);
            if (unloginAccess != null) {
                return true;
            }
        }
        try {
            ShopUserCookieDto shopUserCookieDto = UserUtils.getUserCookieDto(request);
            RequestLocal.setUser(shopUserCookieDto);
        } catch (Exception e) {
            String message = JSONObject.toJSONString(ResultBuilder.fail(e.getMessage()));
            writeResult(response, message);
            return false;
        }
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        HandlerInterceptor.super.postHandle(request, response, handler, modelAndView);
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        HandlerInterceptor.super.afterCompletion(request, response, handler, ex);
    }

    /**
     * 返回信息
     *
     * @param response
     * @param result
     */
    private void writeResult(HttpServletResponse response, String result) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        try (PrintWriter out = response.getWriter()) {
            out.write(result);
            out.flush();
        } catch (Exception e) {
            //ignore
        }
    }
}
