package cn.com.duiba.jdactivity.developer.jd.utils;

import cn.com.duiba.jdactivity.developer.jd.domain.JosParameters;
import cn.com.duiba.jdactivity.developer.jd.domain.StateParam;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import org.apache.commons.lang3.StringUtils;

import java.util.Base64;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/5/13 14:45
 */
public class LoginUtils {

    private static final String NULL = "null";

    public static JosParameters getStateParam(String state) {
        if (StringUtils.isBlank(state) || StringUtils.equalsIgnoreCase(NULL, state)) {
            return null;
        }
        // state 中如果有 “+” 号，因浏览器交互的原因，会出现 “+” 号替换成空格的现象，导致授权报错，如果出现此种情况，请把的 state 中的空格再替换成 “+” 号
        state = state.replace(" ", "+");

        String stateBody = new String(Base64.getDecoder().decode(state));

        if (StringUtils.isNoneBlank(stateBody)
                && !StringUtils.equalsIgnoreCase(NULL, stateBody)
                && JSONValidator.from(stateBody).validate()) {
            StateParam stateParam = JSONObject.parseObject(stateBody, StateParam.class);
            return stateParam.getJosParameters();
        }
        return null;

    }


    public static void main(String[] args) {
        System.out.println(JSON.toJSONString(getStateParam(
                "eyJqb3NfcGFyYW1ldGVycyI6eyJlbmRfZGF0ZSI6MTYyMTkzOTkzMDAwMCwidmVyc2lvbl9ubyI6MiwiaXRlbV9jb2RlIjoiRldfR09PRFMtNTQ5MjExLTIiLCJhcHBfa2V5IjoiMWJhZGExYWFlZDEzNGM2OTk2ZjMxZTgxZDM3MmFjNDgiLCJ1c2VyX25hbWUiOiJkdWliYTIwMjFqZCIsImFydGljbGVfbnVtIjoxfX0=")));
    }
}
