package cn.com.duiba.jdactivity.common.vo;


import cn.com.duiba.jdactivity.interceptor.RecordInterceptor;
import org.slf4j.MDC;

/**
 * Created by zzy on 2017/10/30.
 */
public final class ResultBuilder {

    private ResultBuilder() {
    }

    /**
     * 失败
     *
     * @param code
     * @param desc
     * @param <T>
     * @return
     */
    public static <T> Result<T> fail(String code, String desc) {
        Result<T> result = newInstance();
        result.setSuccess(false);
        result.setCode(code);
        result.setDesc(desc);
        return result;
    }

    private static <T> Result<T> newInstance() {
        Result<T> result = new Result<>();
        result.setTimestamp(System.currentTimeMillis());
        result.setRequestId(MDC.get(RecordInterceptor.REQUEST_ID_KEY));
        return result;
    }

    /**
     * 前端对于需要根据错误信息做不同的处理时,可以定义多个业务异常枚举,通过code进行区分
     *
     * @param resultCode 业务错误枚举类
     * @param <T>
     * @return
     * @see ResultCode
     */
    public static <T> Result<T> fail(ResultCode resultCode) {
        return fail(resultCode.getCode(), resultCode.getDescription());
    }

    /**
     * 可以自定义错误提示，统一使用默认错误码，不需要去添加业务异常枚举类
     *
     * @param desc
     * @param <T>
     * @return
     */
    public static <T> Result<T> fail(String desc) {
        return fail(ResultCode.C100000.getCode(), desc);
    }

    /**
     * 带有数据的失败返回，统一使用默认错误码，不需要去添加业务异常枚举类
     *
     * @param resultCode
     * @param data
     * @param <T>
     * @return
     */
    public static <T> Result<T> fail(ResultCode resultCode, T data) {
        Result<T> result = fail(resultCode);
        result.setData(data);
        return result;
    }

    /**
     * 成功
     *
     * @param data
     * @param <T>
     * @return
     */
    public static <T> Result<T> success(T data) {
        Result<T> result = newInstance();
        result.setSuccess(true);
        result.setData(data);
        return result;
    }

    /**
     * 成功,不返回任何数据
     *
     * @param <T>
     * @return
     */
    public static <T> Result<T> success() {
        return success(null);
    }

}
