package cn.com.duiba.jdactivity.controller;

import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.jdactivity.common.utils.AESCS7Util;
import cn.com.duiba.jdactivity.common.utils.RequestTool;
import cn.com.duiba.jdactivity.common.vo.Result;
import cn.com.duiba.jdactivity.common.vo.ResultBuilder;
import cn.com.duiba.jdactivity.developer.duiba.DuibaAppEnum;
import cn.com.duiba.jdactivity.developer.jd.constant.JdAppEnum;
import cn.com.duiba.jdactivity.developer.jd.utils.AccessTokenUtils;
import cn.com.duiba.jdactivity.developer.jd.utils.JdApiUtil;
import cn.com.duiba.jdactivity.dto.*;
import cn.com.duiba.jdactivity.exception.BizException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.jd.open.api.sdk.domain.crm.VenderCustomerClientJsfService.response.getCustomer.EssentialCustomerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @ClassName：TaobaoController
 * @Description：描述
 * @Author：haozengrun
 * @Date：2021/11/17 上午9:50
 * @Versiion：1.0
 */
@RestController
@RequestMapping("/taobao")
public class TaobaoController {
    public static final Logger LOGGER = LoggerFactory.getLogger(TaobaoController.class);
    public static final String ENCRYPT_KEY = "JuGi3FCECD1dA2BPL1lCWC==";
    //默认超时或提前5分钟
    private static final long DEFAULT_EXPIRE_TIME = 5 * 60 * 1000L;
    @Resource
    private JdApiUtil jdApiUtil;
    @Resource
    private AccessTokenUtils accessTokenUtils;

    private static String encodeSecret(String secret) {
        byte[] unencodedPassword = secret.getBytes();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("sha");
        } catch (Exception e) {
            e.printStackTrace();
            return secret;
        }
        md.reset();
        md.update(unencodedPassword);
        byte[] encodedPassword = md.digest();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < encodedPassword.length; i++) {
            if ((encodedPassword[i] & 0xff) < 0x10) {
                buf.append("0");
            }
            buf.append(Long.toString(encodedPassword[i] & 0xff, 16));
        }
        return buf.toString();
    }

    /**
     * 签名校验
     */
    private static <T extends DuibaUserParam> void signVerify4Post(T param, String method) throws BizException {
        String jsonString = JSON.toJSONString(param);
        LOGGER.info(method + "参数：" + jsonString);
        //前后5分钟内有效
        String timestamp = param.getTimestamp();
        String appKey = param.getAppKey();
        String sign = param.getSign();
        LOGGER.info("appKey：" + appKey);
        DuibaAppEnum duibaAppEnum = DuibaAppEnum.getDuibaApp(appKey);
        if (duibaAppEnum == null) {
            throw new BizException("appKey不存在");
        }
        long clientTimestamp = timestamp == null ? 0L : Long.parseLong(timestamp);
        long now = System.currentTimeMillis();
        if (Math.abs(now - clientTimestamp) > DEFAULT_EXPIRE_TIME) {
            throw new BizException(String.format("请同步服务器与客户端时间为%s分钟之内", DEFAULT_EXPIRE_TIME));
        }

        String correctSign = encodeSecret(duibaAppEnum.getAppSecret());

        LOGGER.info("signVerify={},correctSign={}", sign, correctSign);

        if (!correctSign.equals(sign)) {
            throw new BizException("签名校验不正确");
        }
    }

    /**
     * 是否关注店铺
     */
    @PostMapping("/isFollowShop")
    public Result<Boolean> isFollowShop(@RequestBody DuibaUserParam duibaUserParam) {
        try {
            String uid = getUid(duibaUserParam.getUid());
            signVerify4Post(duibaUserParam, "是否关注店铺");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(duibaUserParam);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);
            Result<Boolean> follow = jdApiUtil.isFollowByPinAndVid(appEnum, pin, duibaUserParam.getShopId());
            LOGGER.info("是否关注店铺,follow={},uid={},pin={}", JSON.toJSONString(follow), uid, pin);
            return follow;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("isFollowShop 异常", e);
            return ResultBuilder.fail("发生异常");
        }
    }


    public static String convert2Pin(JdAppEnum appByAppKey, String accessToken, String uid) throws BizException {
        try {
            String pin = AESCS7Util.AES256Decrypt(uid, ENCRYPT_KEY);
            LOGGER.info("uid解密,pin={},uid={}", pin, uid);
            return pin;
        } catch (Exception e) {
            LOGGER.error("uid解密失败,uid={}", uid, e);
            throw new BizException("uid解密失败");
        }

    }

    /**
     * 关注店铺
     */
    @PostMapping("/followShop")
    public Result<Boolean> followShop(@RequestBody DuibaUserParam duibaUserParam) {
        try {
            String uid = getUid(duibaUserParam.getUid());
            signVerify4Post(duibaUserParam, "关注店铺");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(duibaUserParam);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);
            Result<Boolean> follow = jdApiUtil.followByPinAndVid(appEnum, pin, duibaUserParam.getShopId(), accessToken.getAccessToken());
            LOGGER.info("关注店铺,follow={},uid={},pin={}", JSON.toJSONString(follow), uid, pin);
            return follow;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("followShop 异常", e);
            return ResultBuilder.fail("发生异常");
        }
    }

    /**
     * 获取商品详情
     */
    @PostMapping("/getGoodsDetail")
    public Result<String> getGoodsDetail(@RequestBody GoodsDetailsParams goodsDetailsParams) {
        try {
            String uid = getUid(goodsDetailsParams.getUid());
            signVerify4Post(goodsDetailsParams, "商品详情");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(goodsDetailsParams);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);
            Result<String> follow = jdApiUtil.getGoodsDetail(appEnum, accessToken.getAccessToken(), goodsDetailsParams.getWareId());
            LOGGER.info("关注店铺,follow={},uid={},pin={}", JSON.toJSONString(follow), uid, pin);
            return follow;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("followShop 异常", e);
            return ResultBuilder.fail("发生异常");
        }
    }

    /**
     * 获取单个商品
     */
    @PostMapping("/findWareById")
    public Result<String> findWareById(@RequestBody FindWareByIdParam findWareByIdParam) {
        try {
            String uid = getUid(findWareByIdParam.getUid());
            signVerify4Post(findWareByIdParam, "商品详情");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(findWareByIdParam);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);
            Result<String> follow = jdApiUtil.findWareById(appEnum, accessToken.getAccessToken(), findWareByIdParam.getWareId());
            LOGGER.info("关注店铺,follow={},uid={},pin={}", JSON.toJSONString(follow), uid, pin);
            return follow;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("followShop 异常", e);
            return ResultBuilder.fail("发生异常");
        }
    }

    /**
     * 是否是会员
     */
    @PostMapping("/isMember")
    public Result<Boolean> isMember(@RequestBody DuibaUserParam duibaUserParam) {
        try {
            String uid = getUid(duibaUserParam.getUid());
            signVerify4Post(duibaUserParam, "是否是会员");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(duibaUserParam);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);
            Result<EssentialCustomerInfo> result = jdApiUtil.getCustomer(appEnum, accessToken.getAccessToken(), pin);
            boolean isMember = result.getSuccess() && result.getData() != null &&
                    (result.getData().getLevelAtShop() != null || result.getData().getCustomerPin() != null);
            LOGGER.info("是否是会员,isMember={},uid={},pin={}", isMember, uid, pin);
            return ResultBuilder.success(isMember);
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("是否是会员异常", e);
            return ResultBuilder.fail("是否是会员异常");
        }
    }

    private static String getUid(String uid2) {
        String uid = uid2;
        uid = uid.replaceAll(" ", "+");
        return uid;
    }


    /**
     * 发放优惠券
     */
    @PostMapping("/sendCouponId")
    public Result<Boolean> sendCouponId(@RequestBody DuibaSendCouponParam param) {
        try {
            String uid = param.getUid();
            Long couponId = param.getCouponId();
            String uuid = param.getUuid();

            uid = uid.replaceAll(" ", "+");
            signVerify4Post(param, "发放优惠券");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(param);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);

            Result<Boolean> sendCouponResult = jdApiUtil.pushCoupon(appEnum, accessToken.getAccessToken(), couponId, pin, uuid);
            LOGGER.info("发放优惠券,sendCouponResult={},uid={},pin={},uuid={}", JSON.toJSONString(sendCouponResult), uid, pin, uuid);
            if (!sendCouponResult.getSuccess()) {
                // 如果失败是因为未锁券
                if (Objects.equals("67", sendCouponResult.getCode())) {
                    // 锁券
                    sendCouponResult = jdApiUtil.lockCoupon(appEnum, accessToken.getAccessToken(), couponId);
                    if (sendCouponResult.getSuccess()) {
                        // 再发券
                        sendCouponResult = jdApiUtil.pushCoupon(appEnum, accessToken.getAccessToken(), couponId, pin, uuid);
                    }
                }
            }
            return sendCouponResult;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("发券异常", e);
            return ResultBuilder.fail("发券失败");
        }
    }

    /**
     * 会员信息，包含首次成为会员的时间、会员等级、总订单金额、总下单次数、客单价、最新订单时间
     */
    @PostMapping("/memberInfo")
    public Result<EssentialCustomerInfo> memberInfo(@RequestBody DuibaUserParam duibaUserParam) {
        try {
            String uid = getUid(duibaUserParam.getUid());
            signVerify4Post(duibaUserParam, "会员信息");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(duibaUserParam);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);
            Result<EssentialCustomerInfo> result = jdApiUtil.getCustomer(appEnum, accessToken.getAccessToken(), pin);
            if (!result.getSuccess()) {
                return result;
            }
            EssentialCustomerInfo customerInfo = result.getData();
            boolean isMember = customerInfo != null && (customerInfo.getLevelAtShop() != null || customerInfo.getCustomerPin() != null);
            if (!isMember) {
                return ResultBuilder.success();
            }
            LOGGER.info("会员信息,customerInfo={},uid={},pin={}", JSON.toJSONString(customerInfo), uid, pin);
            return ResultBuilder.success(customerInfo);
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("会员信息异常", e);
            return ResultBuilder.fail("会员信息异常");
        }
    }

    /**
     * 发放店铺积分
     */
    @PostMapping("/sendPoints")
    public Result<Boolean> sendPoints(@RequestBody DuibaSendPointsParam param) {
        try {
            String uid = getUid(param.getUid());
            signVerify4Post(param, "互动积分发放积分");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(param);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);

            Result<Boolean> result = jdApiUtil.sendPoints(
                    appEnum, pin, param.getBusinessId(), param.getPoints(), param.getDesc(), accessToken.getAccessToken());
            LOGGER.info("互动积分发放积分,result={},uid={},pin={}", JSON.toJSONString(result), uid, pin);
            return result;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("互动积分发放积分,异常", e);
            return ResultBuilder.fail("互动积分发放积分异常");
        }
    }

    /**
     * 消费店铺积分
     */
    @PostMapping("/consumePoints")
    public Result<Boolean> consumePoints(@RequestBody DuibaSendPointsParam param) {
        try {
            String uid = getUid(param.getUid());
            signVerify4Post(param, "互动积分消费积分");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(param);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);

            Result<Boolean> result = jdApiUtil.consumePoints(
                    appEnum, pin, param.getBusinessId(), param.getPoints(), param.getDesc(), accessToken.getAccessToken());
            LOGGER.info("互动积分消费积分,result={},uid={},pin={}", JSON.toJSONString(result), uid, pin);
            return result;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("互动积分消费积分,异常", e);
            return ResultBuilder.fail("互动积分消费积分异常");
        }
    }

    /**
     * 获取用户积分值
     */
    @PostMapping("/getCustomerPoints")
    public Result<Long> getCustomerPoints(@RequestBody DuibaUserParam param) {
        try {
            String uid = getUid(param.getUid());
            signVerify4Post(param, "获取用户积分");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(param);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);

            Result<Long> result = jdApiUtil.getCustomerPoints(appEnum, pin, accessToken.getAccessToken());
            LOGGER.info("获取用户积分,result={},uid={},pin={}", JSON.toJSONString(result), uid, pin);
            return result;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("获取用户积分,异常", e);
            return ResultBuilder.fail("获取用户积分异常");
        }
    }


    /**
     * 通过用户pin加入购物车
     */
    @PostMapping("/addCartItemByPin")
    public Result<Boolean> addCartItemByPin(@RequestBody DuibaAddCartParam param) {
        try {
            String uid = param.getUid();
            Integer num = param.getNum();
            String itemId = param.getItemId();

            uid = uid.replaceAll(" ", "+");
            signVerify4Post(param, "通过用户pin加入购物车");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(param);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);

            Result<Boolean> result = jdApiUtil.addCartItemByPin(appEnum, pin, itemId, num, accessToken.getAccessToken());
            LOGGER.info("通过用户pin加入购物车,result={}", JSON.toJSONString(result));
            return result;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("通过用户pin加入购物车,异常", e);
            return ResultBuilder.fail("通过用户pin加入购物车失败");
        }
    }


    /**
     * 发送京豆
     */
    @PostMapping("/sendBean")
    public Result<Boolean> sendBean(@RequestBody DuibaSendBeanParam param) {
        try {
            String uid = param.getUid();

            uid = uid.replaceAll(" ", "+");
            signVerify4Post(param, "发送京豆");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(param);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);

            Result<Boolean> result = jdApiUtil.sendBean(appEnum, accessToken.getAccessToken(),
                    param.getRequestId(), param.getBeanNum(), accessToken.getVenderId(),
                    param.getPlanId(), pin, param.getDesc());
            LOGGER.info("发送京豆,result={}", JSON.toJSONString(result));
            return result;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("发送京豆,异常", e);
            return ResultBuilder.fail("通过用户pin加入购物车失败");
        }
    }

    /**
     * 关注商品
     */
    @PostMapping("/followGood")
    public Result<Boolean> followGood(@RequestBody FollowGoodParam param) {
        try {
            String uid = param.getUid();
            Long productId = param.getProductId();

            uid = uid.replaceAll(" ", "+");
            signVerify4Post(param, "关注商品");

            TbShopAccessTokenDto accessToken = accessTokenUtils.getAccessTokenWithCache(param);
            JdAppEnum appEnum = JdAppEnum.getAppByAppKey(accessToken.getAppKey());
            String pin = convert2Pin(appEnum, accessToken.getAccessToken(), uid);

            Result<Boolean> result = jdApiUtil.followGood(appEnum, pin, productId, accessToken.getAccessToken());
            LOGGER.info("关注商品,result={}", JSON.toJSONString(result));
            return result;
        } catch (BizException e) {
            return ResultBuilder.fail(e.getMessage());
        } catch (Exception e) {
            LOGGER.error("关注商品,异常", e);
            return ResultBuilder.fail("关注商品失败");
        }
    }
}
