package cn.com.duiba.jdactivity.developer.jd.constant;

import java.util.Objects;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/5/13 14:56
 */
@SuppressWarnings("AlibabaEnumConstantsMustHaveComment")
public enum JdAppEnum {
    DUIBA("互动营销-兑吧", "B0F491866BC8C8BA5954B4DFCCF283CC", "571df532d10c4c1e839cef1f1a9a2113", "https://duiba-isv.isvjcloud.com");

    private final String appName;
    private final String appKey;
    private final String appSecret;
    /**
     * 应用信息设置的回调地址
     */
    private String url;

    JdAppEnum(String appName, String appKey, String appSecret, String url) {
        this.appName = appName;
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.url = url;
    }

    public String getAppName() {
        return appName;
    }

    public String getAppKey() {
        return appKey;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public String getUrl() {
        return url;
    }


    public static JdAppEnum getAppByAppKey(String appKey) {
        for (JdAppEnum jdAppEnum : JdAppEnum.values()) {
            if (Objects.equals(jdAppEnum.getAppKey(), appKey)) {
                return jdAppEnum;
            }
        }
        return null;
    }
}
