package cn.com.duiba.jdactivity.service.impl;

import cn.com.duiba.jdactivity.dao.TbShopAccessTokenDao;
import cn.com.duiba.jdactivity.dto.TbShopAccessTokenDto;
import cn.com.duiba.jdactivity.entity.TbShopAccessTokenEntity;
import cn.com.duiba.jdactivity.service.TbShopAccessTokenService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 店铺授权表(TbShopAccessToken)表服务实现类
 *
 * @author makejava
 * @since 2021-05-17 16:12:54
 */
@Service("tbShopAccessTokenService")
public class TbShopAccessTokenServiceImpl implements TbShopAccessTokenService {
    @Resource
    private TbShopAccessTokenDao tbShopAccessTokenDao;

    private static TbShopAccessTokenDto convert2Dto(TbShopAccessTokenEntity entity) {
        TbShopAccessTokenDto tbShopAccessTokenDto = new TbShopAccessTokenDto();
        BeanUtils.copyProperties(entity, tbShopAccessTokenDto);
        return tbShopAccessTokenDto;
    }

    private static TbShopAccessTokenEntity convert2Entity(TbShopAccessTokenDto accessTokenDto) {
        TbShopAccessTokenEntity tokenEntity = new TbShopAccessTokenEntity();
        BeanUtils.copyProperties(accessTokenDto, tokenEntity);
        return tokenEntity;
    }

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    @Override
    public TbShopAccessTokenDto queryById(Long id) {
        TbShopAccessTokenEntity entity = tbShopAccessTokenDao.queryById(id);
        if (entity == null) {
            return null;
        }
        return convert2Dto(entity);
    }

    @Override
    public List<TbShopAccessTokenDto> queryByVenderIdShopId(Long venderId, Long shopId) {
        List<TbShopAccessTokenEntity> entities = tbShopAccessTokenDao.queryByVenderIdShopId(venderId, shopId);
        if (CollectionUtils.isEmpty(entities)) {
            return Collections.emptyList();
        }

        return entities.stream().map(TbShopAccessTokenServiceImpl::convert2Dto).collect(Collectors.toList());
    }

    /**
     * 新增数据
     *
     * @param tbShopAccessTokenDto 实例对象
     * @return 实例对象
     */
    @Override
    public Long insert(TbShopAccessTokenDto tbShopAccessTokenDto) {
        if (tbShopAccessTokenDto == null) {
            return 0L;
        }
        TbShopAccessTokenEntity entity = convert2Entity(tbShopAccessTokenDto);
        tbShopAccessTokenDao.insertOrUpdate(entity);
        return entity.getId();
    }

    /**
     * 修改数据
     *
     * @param tbShopAccessTokenDto 实例对象
     * @return 实例对象
     */
    @Override
    public int update(TbShopAccessTokenDto tbShopAccessTokenDto) {
        if (tbShopAccessTokenDto == null) {
            return 0;
        }
        return tbShopAccessTokenDao.update(convert2Entity(tbShopAccessTokenDto));
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    @Override
    public boolean deleteById(Long id) {
        return tbShopAccessTokenDao.deleteById(id) > 0;
    }
}
