package cn.com.duiba.jdactivity.developer.duiba;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * 兑吧app，后续想个灵活的方式
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/5/18 15:58
 */
public enum DuibaAppEnum {
    WX("微信公众号测试", "3bRVpGghtsQXXeZpVH4VGi92Nr7V", "28Ujh91mWeKSCZ4ndDyLWf527TN1"),
    JD_ACTIVITY_TEST("19543-京东活动测试-测试", "oZ1hxUrKW95Qn9P4BZpSGSTdUDZ", "3kQU8Rp31zifPiypTqVmujQ1h5X4"),
    TEST_4_27("4-27测试", "22KCCnB22yZihPnuB8gpqZhtdAka", "ct8j6grNJ5cCqQcN1c8sTdSEdcK"),
    BOSIDENG_PROD("波司登线上", "4EBS3taRKgKpKKSVg4xv4UnfEESh", "2hMzuvExEE7XzfThv2fbnUKxRsXA"),
    GANGBEN_PROD("冈本-线上", "2NWc2qqfEzMoCDzFpF2q7cTPYJWc", "3dFe4VbW7PqAiTGrJiehRaVUPLUw"),
    YITOUNIU_PROD("认养一头牛-线上", "3o57frWzQKcM69QcdZ8PnADLBSe6", "4pcBKccw5fCTN5roiwbf5eTGoMU"),
    FEILE_PROD("斐乐双十一集卡", "2kfyJJbJo1Rb9f8F3Yc7EG5atZ2Y", "2yDkxPx9NdmZQc7TxRQKjJiCgLrP"),
    ;


    private final String appName;
    private final String appKey;
    private final String appSecret;

    DuibaAppEnum(String appName, String appKey, String appSecret) {
        this.appName = appName;
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public String getAppName() {
        return appName;
    }

    public String getAppKey() {
        return appKey;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public static DuibaAppEnum getDuibaApp(String appKey) {
        if (StringUtils.isBlank(appKey)) {
            return null;
        }
        for (DuibaAppEnum value : values()) {
            if (Objects.equals(value.getAppKey(), appKey)) {
                return value;
            }
        }
        return null;
    }
}
