package cn.com.duiba.jdactivity.developer.jd.utils;

import cn.com.duiba.jdactivity.developer.jd.constant.JdAppEnum;
import cn.com.duiba.jdactivity.developer.jd.constant.JdServerUrlEnum;
import com.jd.security.tdeclient.SecretJdClient;
import com.jd.security.tdeclient.TDEClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/5/18 16:04
 */
@Component
public class EncryptUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger(EncryptUtil.class);

    public String encryptString(JdAppEnum jdAppEnum, String accessToken, String plaintext) {
        try {
            TDEClient tdeClient = getClient(jdAppEnum, accessToken);
            return tdeClient.encryptString(plaintext);
        } catch (Exception e) {
            LOGGER.warn("encryptString,exception", e);
            return null;
        }
    }


    public String decryptString(JdAppEnum jdAppEnum, String accessToken, String ciphertext) {
        try {
            TDEClient tdeClient = getClient(jdAppEnum, accessToken);
            return tdeClient.decryptString(ciphertext);
        } catch (Exception e) {
            LOGGER.warn("decryptString,exception", e);
            return null;
        }
    }

    private TDEClient getClient(JdAppEnum jdAppEnum, String accessToken) throws Exception {
        return SecretJdClient.getInstance(JdServerUrlEnum.API_URL.getUrl(), accessToken, jdAppEnum.getAppKey(), jdAppEnum.getAppSecret());
    }
}
