package cn.com.duiba.jdactivity.common.vo;

/**
 * 用于管理使用系统的所有返回码，避免业务code重复<br>
 * 用法：枚举_业务参数
 */
public enum ResultCode {

    /**
     * 状态码
     */
    C100000("100000", "默认错误码"),
    C100001("100001", "用户未登录"),
    C100002("100002", "参数错误"),
    C100003("100003", "token错误"),
    C100004("100004", "用户不存在"),
    C100005("100005", "活动不存在"),
    C100006("100006", "活动已结束"),


    //命中风控参与规则
    C777777("777777", "网络错误"),
    C999999("999999", "系统繁忙，请稍候"),


    ;


    /**
     * 错误码
     */
    private String code;
    /**
     * 业务错误描述
     */
    private String description;

    ResultCode(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    /**
     * 得到描述
     *
     * @return {@link String}
     */
    public String getDescription() {
        return description;
    }


}
