package cn.com.duiba.jdactivity.dao.impl;

import cn.com.duiba.jdactivity.config.DbSchemaConstants;
import cn.com.duiba.jdactivity.dao.BaseDao;
import cn.com.duiba.jdactivity.dao.TbShopAccessTokenDao;
import cn.com.duiba.jdactivity.entity.TbShopAccessTokenEntity;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/5/17 16:21
 */
@Repository
public class TbShopAccessTokenDaoImpl extends BaseDao implements TbShopAccessTokenDao {


    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    @Override
    public TbShopAccessTokenEntity queryById(Long id) {
        Map<String, Long> param = Maps.newHashMap();
        param.put("id", id);
        return selectOne("queryById", param);
    }

    @Override
    public List<TbShopAccessTokenEntity> queryByVenderIdShopId(Long venderId, Long shopId) {
        Map<String, Long> param = Maps.newHashMap();
        param.put("venderId", venderId);
        param.put("shopId", shopId);
        return selectList("queryByVenderIdShopId", param);
    }

    @Override
    public int insertOrUpdate(TbShopAccessTokenEntity tbShopAccessToken) {
        Map<String, Object> param = Maps.newHashMap();
        param.put("entity", tbShopAccessToken);
        return insert("insertOrUpdate", param);
    }

    /**
     * 修改数据
     *
     * @param tbShopAccessToken 实例对象
     * @return 影响行数
     */
    @Override
    public int update(TbShopAccessTokenEntity tbShopAccessToken) {
        return update("update", tbShopAccessToken);
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    @Override
    public int deleteById(Long id) {
        Map<String, Long> param = Maps.newHashMap();
        param.put("id", id);
        return delete("deleteById", param);
    }

    /**
     * 这个方法延迟到子类实现,由子类决定注入哪个sqlSessionTemplate,以使用不同的库
     *
     * @return
     */
    @Override
    protected String chooseSchema() {
        return DbSchemaConstants.DATABASE_CUSTOM;
    }
}
